% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-npi.R
\name{npi_add_school_closure}
\alias{npi_add_school_closure}
\title{School closure intervention (non-pharmaceutical intervention)}
\usage{
npi_add_school_closure(model, preval, day, transmission_reduction)
}
\arguments{
\item{model}{epiworldR model.}

\item{preval}{Prevalence of school closure within the population.}

\item{day}{Day in the simulation where school closure goes into effect.}

\item{transmission_reduction}{Reduction in transmission probability due to school closure.}
}
\value{
Returns an object of class epiworld_model, where model is
substituted with the model name.
}
\description{
School closure intervention (non-pharmaceutical intervention)
}
\examples{
library(epiworldR) # for ModelSEIRCONN function
model <- ModelSEIRCONN("COVID-19", n = 1000, prevalence = 0.05,
                       contact_rate = 4, transmission_rate = 0.1,
                       incubation_days = 7, recovery_rate = 0.14)
run(model, ndays = 100, seed = 123)
npi_add_school_closure(model, preval = .8, transmission_reduction = .3, day = 10)
}
\seealso{
Other interventions: 
\code{\link{interventions_add_all}()},
\code{\link{npi_add_masking}()},
\code{\link{pi_add_vaccine}()}
}
\concept{interventions}
