% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\docType{class}
\name{IdfGeometry}
\alias{IdfGeometry}
\alias{idf_geometry}
\title{Modify and Visualize an EnergyPlus Model Geometry}
\usage{
idf_geometry(parent, object = NULL)
}
\arguments{
\item{parent}{A path to an IDF file or an \link{Idf} object.}

\item{object}{A character vector of valid names or an integer
vector of valid IDs of objects to extract. If \code{NULL}, all
objects in geometry classes will be extracted.}
}
\value{
An \code{IdfGeometry} object.
}
\description{
\code{IdfGeometry} is an abstraction of a collection of geometry in an \link{Idf}. It
provides more detail methods to query geometry properties, update geometry
vertices and visualize geometry in 3D using the
\href{https://cran.r-project.org/package=rgl}{rgl} package.
}
\examples{

## ------------------------------------------------
## Method `IdfGeometry$new`
## ------------------------------------------------

\dontrun{
# example model shipped with eplusr from EnergyPlus v8.8
path_idf <- system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr") # v8.8

# create from an Idf object
idf <- read_idf(path_idf, use_idd(8.8, "auto"))
geom <- idf$geometry()
geom <- IdfGeometry$new(idf)

# create from an IDF file
geom <- idf_geometry(path_idf)
geom <- IdfGeometry$new(path_idf)
}

## ------------------------------------------------
## Method `IdfGeometry$parent`
## ------------------------------------------------

\dontrun{
geom$parent()
}

## ------------------------------------------------
## Method `IdfGeometry$rules`
## ------------------------------------------------

\dontrun{
geom$rules()
}

## ------------------------------------------------
## Method `IdfGeometry$convert`
## ------------------------------------------------

\dontrun{
geom$convert()
}

## ------------------------------------------------
## Method `IdfGeometry$coord_system`
## ------------------------------------------------

\dontrun{
geom$coord_system("absolute", "absolute", "absolute")
}

## ------------------------------------------------
## Method `IdfGeometry$round_digits`
## ------------------------------------------------

\dontrun{
geom$round_digits()
}

## ------------------------------------------------
## Method `IdfGeometry$area`
## ------------------------------------------------

\dontrun{
geom$area()
}

## ------------------------------------------------
## Method `IdfGeometry$azimuth`
## ------------------------------------------------

\dontrun{
geom$azimuth()
}

## ------------------------------------------------
## Method `IdfGeometry$tilt`
## ------------------------------------------------

\dontrun{
geom$tilt()
}

## ------------------------------------------------
## Method `IdfGeometry$view`
## ------------------------------------------------

\dontrun{
idf$view()
idf$view(render_by = "zone")
idf$view(new = TRUE, render_by = "construction")
}

## ------------------------------------------------
## Method `IdfGeometry$print`
## ------------------------------------------------

\dontrun{
geom$print()
}
}
\seealso{
\link{Idf} class
}
\author{
Hongyuan Jia
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{IdfGeometry$new()}}
\item \href{#method-parent}{\code{IdfGeometry$parent()}}
\item \href{#method-rules}{\code{IdfGeometry$rules()}}
\item \href{#method-convert}{\code{IdfGeometry$convert()}}
\item \href{#method-coord_system}{\code{IdfGeometry$coord_system()}}
\item \href{#method-round_digits}{\code{IdfGeometry$round_digits()}}
\item \href{#method-area}{\code{IdfGeometry$area()}}
\item \href{#method-azimuth}{\code{IdfGeometry$azimuth()}}
\item \href{#method-tilt}{\code{IdfGeometry$tilt()}}
\item \href{#method-view}{\code{IdfGeometry$view()}}
\item \href{#method-print}{\code{IdfGeometry$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an \code{IdfGeometry} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfGeometry$new(parent, object = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent}}{A path to an IDF file or an \link{Idf} object.}

\item{\code{object}}{A character vector of valid names or an integer
vector of valid IDs of objects to extract. If \code{NULL}, all
objects in geometry classes will be extracted.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{IdfGeometry} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# example model shipped with eplusr from EnergyPlus v8.8
path_idf <- system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr") # v8.8

# create from an Idf object
idf <- read_idf(path_idf, use_idd(8.8, "auto"))
geom <- idf$geometry()
geom <- IdfGeometry$new(idf)

# create from an IDF file
geom <- idf_geometry(path_idf)
geom <- IdfGeometry$new(path_idf)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parent"></a>}}
\if{latex}{\out{\hypertarget{method-parent}{}}}
\subsection{Method \code{parent()}}{
Get parent \link{Idf} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfGeometry$parent()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$parent()} returns the parent \link{Idf} object of current \code{IdfGeometry}
object.
}

\subsection{Returns}{
An \link{Idf} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
geom$parent()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rules"></a>}}
\if{latex}{\out{\hypertarget{method-rules}{}}}
\subsection{Method \code{rules()}}{
Get global geometry rules
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfGeometry$rules()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$rules()} returns global geometry rules.
}

\subsection{Returns}{
An \link{Idf} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
geom$rules()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-convert"></a>}}
\if{latex}{\out{\hypertarget{method-convert}{}}}
\subsection{Method \code{convert()}}{
Convert simple geometry objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfGeometry$convert(type = c("surface", "subsurface", "shading"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{A character vector giving what types of simplified
geometries should be converted. Should be a subset of
\code{"surface"}, \code{"subsurface"} and \code{"shading"}. Default is set to
all of them.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
EnergyPlus provides several classes that allow for simplified entry
of geometries, such as \code{Wall:Exterior}, \code{Window} and etc.
\verb{$convert()} will generate detailed vertices from simplified geometry
specifications and replace the original object with its corresponding
detailed class, including:
\itemize{
\item \code{BuildingSurface:Detailed}
\item \code{FenestrationSurface:Detailed}
\item \code{Shading:Site:Detailed}
\item \code{Shading:Building:Detailed}
\item \code{Shading:Zone:Detailed}
}
}

\subsection{Returns}{
The modified \link{Idf} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
geom$convert()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-coord_system"></a>}}
\if{latex}{\out{\hypertarget{method-coord_system}{}}}
\subsection{Method \code{coord_system()}}{
Convert vertices to specified coordinate systems
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfGeometry$coord_system(detailed = NULL, simple = NULL, daylighting = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{detailed, simple, daylighting}}{A string specifying the coordinate
system for detailed geometries, simple (rectangular surface)
geometries, and daylighting reference points. Should be one of
\code{"relative"} and \code{"absolute"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$coord_system()} converts all vertices of geometries into specified
coordinate systems, e.g. from absolute to relative, and vice versa.
Besides, it also updates the \code{GlobalGeometryRules} in parent \link{Idf}
accordingly.
}

\subsection{Returns}{
The modified \link{Idf} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
geom$coord_system("absolute", "absolute", "absolute")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-round_digits"></a>}}
\if{latex}{\out{\hypertarget{method-round_digits}{}}}
\subsection{Method \code{round_digits()}}{
Round digits on geometry vertices
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfGeometry$round_digits(digits = 4L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{digits}}{An integer giving the number of decimal places to be
used. Default: \code{4}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$round_digits()} performs number rounding on vertices of detailed
geometry object vertices, e.g. \code{BuildingSurface:Detailed},
\code{FenestrationSurface:Detailed} and etc.

\verb{$round_digits()} may be useful for clean up IDF files generated
using OpenStudio which often gives vertices with long trailing
digits.
}

\subsection{Returns}{
The modified \link{Idf} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
geom$round_digits()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-area"></a>}}
\if{latex}{\out{\hypertarget{method-area}{}}}
\subsection{Method \code{area()}}{
Get area
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfGeometry$area(class = NULL, object = NULL, net = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{class}}{A character vector of valid geometry class names.
Default: \code{NULL}.}

\item{\code{object}}{A character vector of valid names or an integer
vector of valid IDs of targeting objects.
Default: \code{NULL}.}

\item{\code{net}}{If \code{TRUE}, the gross area is returned. If \code{FALSE}, the net
area is returned. Default: \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$area()} returns the area of surfaces in square meters.
}

\subsection{Returns}{
A \code{\link[data.table:data.table]{data.table::data.table()}} of 6 columns:
\itemize{
\item \code{id}: Integer type. Object IDs.
\item \code{name}: Character type. Object names.
\item \code{class}: Character type. Class names.
\item \code{zone}: Character type. Zone names that specified objects belong to.
\item \code{type}: Character type. Surface types.
\item \code{area}: Numeric type. Surface Area in m2.
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
geom$area()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-azimuth"></a>}}
\if{latex}{\out{\hypertarget{method-azimuth}{}}}
\subsection{Method \code{azimuth()}}{
Get azimuth
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfGeometry$azimuth(class = NULL, object = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{class}}{A character vector of valid geometry class names.
Default: \code{NULL}.}

\item{\code{object}}{A character vector of valid names or an integer
vector of valid IDs of targeting objects.
Default: \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$azimuth()} returns the azimuth of surfaces in degree.
}

\subsection{Returns}{
A \code{\link[data.table:data.table]{data.table::data.table()}} of 6 columns:
\itemize{
\item \code{id}: Integer type. Object IDs.
\item \code{name}: Character type. Object names.
\item \code{class}: Character type. Class names.
\item \code{zone}: Character type. Zone names that specified objects belong to.
\item \code{type}: Character type. Surface types.
\item \code{azimuth}: Numeric type. Azimuth in degree.
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
geom$azimuth()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tilt"></a>}}
\if{latex}{\out{\hypertarget{method-tilt}{}}}
\subsection{Method \code{tilt()}}{
Get tilt
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfGeometry$tilt(class = NULL, object = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{class}}{A character vector of valid geometry class names.
Default: \code{NULL}.}

\item{\code{object}}{A character vector of valid names or an integer
vector of valid IDs of targeting objects.
Default: \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$tilt()} returns the tilt of surfaces in degree.
}

\subsection{Returns}{
A \code{\link[data.table:data.table]{data.table::data.table()}} of 6 columns:
\itemize{
\item \code{id}: Integer type. Object IDs.
\item \code{name}: Character type. Object names.
\item \code{class}: Character type. Class names.
\item \code{zone}: Character type. Zone names that specified objects belong to.
\item \code{type}: Character type. Surface types.
\item \code{tilt}: Numeric type. Azimuth in degree.
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
geom$tilt()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-view"></a>}}
\if{latex}{\out{\hypertarget{method-view}{}}}
\subsection{Method \code{view()}}{
View 3D geometry
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfGeometry$view(
  new = FALSE,
  render_by = "surface_type",
  wireframe = TRUE,
  x_ray = FALSE,
  axis = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new}}{If \code{TRUE}, a new rgl window will be open using
\code{\link[rgl:rgl.open]{rgl::rgl.open()}}. If \code{FALSE}, existing rgl window will be
reused if possible. Default: \code{FALSE}.}

\item{\code{render_by}}{A single string specifying the way of rendering the
geometry. Possible values are:
\itemize{
\item \code{"surface_type"}: Default. Render the model by surface type model.
Walls, roofs, windows, doors, floors, and shading surfaces will
have unqiue colors.
\item \code{"boundary"}: Render the model by outside boundary condition. Only
surfaces that have boundary conditions will be rendered with a
color. All other surfaces will be white.
\item \code{"construction"}: Render the model by surface constructions.
\item \code{"zone"}: Render the model by zones assigned.
\item \code{"normal"}: Render the model by surface normal. The outside face of
a heat transfer face will be rendered as white and the inside face
will be rendered as red.
}}

\item{\code{wireframe}}{If \code{TRUE}, the wireframe of each surface will be
shown. Default: \code{TRUE}.}

\item{\code{x_ray}}{If \code{TRUE}, all surfaces wll be rendered translucently.
Default: \code{FALSE}.}

\item{\code{axis}}{If \code{TRUE}, the X, Y and Z axes will be drawn at the
global origin. Default: \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$view()} uses the \href{https://cran.r-project.org/package=rgl}{rgl}
package to visualize the IDF geometry in 3D in a similar way as
\href{https://www.openstudio.net}{OpenStudio}.

\verb{$view()} returns an \link{IdfViewer} object which can be used to further
tweak the viewer scene.

In the rgl window, you can control the view using your mouse:
\itemize{
\item Left button: Trackball
\item Right button: Pan
projection.
\item Wheel: Zoom
}

For more detailed control on the scene, see \link{IdfViewer}.
}

\subsection{Returns}{
An \link{IdfViewer} object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
idf$view()
idf$view(render_by = "zone")
idf$view(new = TRUE, render_by = "construction")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print an \code{IdfGeometry} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdfGeometry$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{IdfGeometry} itself, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
geom$print()
}
}
\if{html}{\out{</div>}}

}

}
}
