% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{use_eplus}
\alias{use_eplus}
\alias{avail_eplus}
\alias{eplus_config}
\alias{is_avail_eplus}
\title{Configure which version of EnergyPlus to use}
\usage{
use_eplus(eplus)

avail_eplus()

eplus_config(ver)

is_avail_eplus(ver)
}
\arguments{
\item{eplus}{An acceptable EnergyPlus version or an EnergyPlus installation
path.}

\item{ver}{An acceptable EnergyPlus version.}
}
\value{
For \code{eplus_config()}, the configure data (a list) of specified
version of EnergyPlus; for \code{avail_eplus()}, a character vector; for
\code{is_avis_avail_eplus()}, a scalar logical vector.
}
\description{
Configure which version of EnergyPlus to use
}
\details{
\code{use_eplus()} adds an EnergyPlus version into the EnergyPlus version
dictionary in eplusr.

\code{eplus_config()} returns the configure data of specified version of
EnergyPlus.

\code{avail_eplus()} returns all available EnergyPlus found.

\code{is_avail_eplus()} checks if the specified version of EnergyPlus is
available or not.
}
\examples{
\dontrun{

use_eplus(8.9)
use_eplus("8.8.0")
eplus_config(8.6)
}

avail_eplus()
is_avail_eplus(8.8)
}
