% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idd.R
\docType{class}
\name{Idd}
\alias{Idd}
\title{Parse, Query and Modify EnergyPlus Input Data Dictionary (IDD)}
\description{
eplusr provides parsing of and programmatic access to EnergyPlus
Input Data Dictionary (IDD) files, and objects. It contains all data needed
to parse EnergyPlus models. \code{Idd} class provides parsing and printing while
\code{IddObject} provides detailed information of curtain class.
}
\section{Overview}{


EnergyPlus operates off of text input files written in its own Input
Data File (IDF) format. IDF files are similar to XML files in that they are
intended to conform to a data schema written using similar syntax. For XML,
the schema format is XSD; for IDF, the schema format is IDD. For each release
of EnergyPlus, valid IDF files are defined by the "Energy+.idd" file shipped
with the release.

eplusr tries to detect all installed EnergyPlus in default installation
locations when loading, i.e. \code{C:\\EnergyPlusVX-X-0} on Windows,
\code{/usr/local/EnergyPlus-X-Y-0} on Linux, and
\code{/Applications/EnergyPlus-X-Y-0} on macOS and stores all found locations
internally. This data is used to locate the distributed "Energy+.idd" file of
each EnergyPlus version. And also, every time an IDD file is parsed, an \code{Idd}
object is created and cached in an environment.

Parsing an IDD file starts from \code{\link[=use_idd]{use_idd()}}. When using \code{\link[=use_idd]{use_idd()}}, eplusr
will first try to find the cached \code{Idd} object of that version, if possible.
If failed, and EnergyPlus of that version is available (see \code{\link[=avail_eplus]{avail_eplus()}}),
the \code{"Energy+.idd"} distributed with EnergyPlus will be parsed and cached. So
each IDD file only needs to be parsed once and can be used when parsing every
IDF file of that version.

Internally, the powerful \href{https://cran.r-project.org/package=data.table}{data.table}
package is used to speed up the whole IDD parsing process and store the
results. However, it will still take about 3-4 sec per IDD.  Under the hook,
eplusr uses a SQL-like structure to store both IDF and IDD data in
\code{data.frame} format. Every IDD will be parsed and stored in twelve tables:
\itemize{
\item \code{group}: contains group index and group names.
\item \code{class}: contains class names and properties.
\item \code{class_memo}: contains class memos, i.e. a brief description on each class.
\item \code{class_reference}: contains reference names of classes.
\item \code{field}: contains field names and field properties.
\item \code{field_note}: contains field notes.
\item \code{field_reference}: contains reference names of fields.
\item \code{field_default}: contains default values of fields.
\item \code{field_choice}: contains choices of choice-type fields.
\item \code{field_range}: contains range data of fields.
\item \code{field_object_list}: contains object-list data of fields.
\item \code{field_external_list}: contains external-list data of fields.
}
}

\section{Usage}{

\preformatted{
idd$version()
idd$build()
idd$group_index(group = NULL)
idd$group_name()
idd$is_valid_group(group)
idd$from_group(class)
idd$class_index(class = NULL)
idd$class_name()
idd$is_valid_class(class)
idd$required_class_name()
idd$unique_class_name()
idd$extenesible_class_name()
idd$object(class)
idd$object_in_group(group)
idd$ClassName
idd[[ClassName]]
idd$clone(deep = FALSE)
idd$print()
print(idd)
}
}

\section{Arguments}{

\itemize{
\item \code{idd}: An \code{Idd} object.
\item \code{group}: A valid group name or valid group names.
\item \code{class}: A valid class name or valid class names.
\item \code{ClassName}: A single length character vector of one valid class name.
}
}

\section{Detail}{


\code{$version()} returns the version string.

\code{$build()} returns the build tag string.

\code{$group_index()} returns integer indexes (indexes of name appearance in
the IDD file) of specified groups.

\code{$group_name()} returns all group names.

\code{$from_group()} returns the names of group that specified classes belongs to.

\code{$is_valid_group()} return \code{TRUE} if the input is a valid group name.

\code{$class_index()} returns integer indexes (indexes of name appearance in
the IDD file) of specified classes.

\code{$class_name()} returns all class names.

\code{$required_class_name()} returns the names of all required classes.

\code{$unique_class_name()} returns the names of all unique classes.

\code{$extensible_class_name()} returns the names of all extensible classes.

\code{$is_valid_class()} return \code{TRUE} if the input is a valid class name.

\code{$objectN} returns a list of \code{IddObject}s of specified classes.

\code{$object_in_group()} returns a list of \code{IddObject}s in that group.

eplusr also provides custom S3 method of \code{$} and \code{[[} to make it
more convenient to get a single \code{IddObject}. Basically, \code{idd$ClassName} and
\code{idd[[ClassName]]}, is equivalent to \code{idd$object(ClassName)[[1]]}.
Here, \code{ClassName} is a single valid class name where all characters other
than letters and numbers are replaced by a underscore \code{_}.

For details about \code{IddObject}, please see \link{IddObject} class.

\code{$clone()} copies and returns the cloned \code{Idd} object. Because \code{Idd} uses
\code{R6Class} under the hook which has "modify-in-place" semantics, \code{idd_2 <- idd_1} does not copy \code{idd_1} at all but only create a new binding to \code{idd_1}.
Modify \code{idd_1} will also affect \code{idd_2} as well, as these two are exactly the
same thing underneath. In order to create a complete cloned copy, please use
\code{$clone(deep = TRUE)}.
}

\examples{
# get the Idd object of EnergyPlus v8.8
idd <- use_idd(8.8, download = "auto")

# version
idd$version()

# build
idd$build()

# all group names
str(idd$group_name())

# all class names
str(idd$class_name())

# all required class names
str(idd$required_class_name())

# all unique class names
str(idd$unique_class_name())

# IddObject of SimulationControl class
idd$SimulationControl
# OR
idd[["SimulationControl"]]

}
\references{
\href{https://github.com/NREL/EnergyPlus/tree/develop/src/IDF_Editor}{IDFEditor}
\href{https://openstudio-sdk-documentation.s3.amazonaws.com/cpp/OpenStudio-2.5.1-doc/utilities/html/idf_page.html}{OpenStudio utilities library}
}
\seealso{
\link{IddObject} class which provides detailed information of
curtain class
}
\author{
Hongyuan Jia
}
