% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dob2age}
\alias{dob2age}
\title{Calculate age from DOB}
\usage{
dob2age(dob, age_on = lubridate::today(), fun = NULL, units = "years", ...)
}
\arguments{
\item{dob}{The date or vector of dates representing date(s) of birth.}

\item{age_on}{(Date) The date on which age is to be calculated.
Defaults to today.}

\item{fun}{(function) The function to be applied to the age, e.g. floor.
Defaults to NULL.}

\item{units}{(character) The units to measure age in, e.g. "years".
Only used if \code{fun} is specified. Defaults to "years".}

\item{...}{Further optional arguments that will be passed to \code{fun}}
}
\value{
(duration) The age as a duration.
}
\description{
Calculate age from DOB
}
\examples{
dob2age(lubridate::as_date("1990-01-01"))
dob2age(
  dob = c(
    lubridate::as_date("1990-01-01"),
    lubridate::as_date("1994-01-01"),
    lubridate::as_date("1998-01-01")
  ),
  age_on = lubridate::as_date("2002-12-31"),
  fun = floor
)
}
