% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{render_epoxy}
\alias{render_epoxy}
\alias{renderEpoxyHTML}
\title{Render Epoxy Output}
\usage{
render_epoxy(
  ...,
  .list = NULL,
  env = parent.frame(),
  outputFunc = ui_epoxy_html,
  outputArgs = list()
)

renderEpoxyHTML(..., env = parent.frame())
}
\arguments{
\item{...}{Named values corresponding to the template variables created with
the associated \code{\link[=ui_epoxy_html]{ui_epoxy_html()}} UI element.}

\item{.list}{A named list or a \code{\link[shiny:reactiveValues]{shiny::reactiveValues()}} list with names
corresponding to the template variables created with the associated
\code{\link[=ui_epoxy_html]{ui_epoxy_html()}} UI element.}

\item{env}{The environment in which to evaluate the \code{...}}

\item{outputFunc}{Either \code{\link[=ui_epoxy_html]{ui_epoxy_html()}} or \code{\link[=ui_epoxy_mustache]{ui_epoxy_mustache()}}, i.e. the
UI function to be paired with this output. This is only used when calling
\code{render_epoxy()} in an Shiny runtime R Markdown document and when you
are only providing the output without an explicit, corresponding UI
element.}

\item{outputArgs}{A list of arguments to be passed through to the implicit
call to \code{\link[=ui_epoxy_html]{ui_epoxy_html()}} when \code{render_epoxy} is used in an interactive R
Markdown document.}
}
\value{
A server-side Shiny render function that should be assigned to
Shiny's \code{output} object and named to match the \code{.id} of the corresponding
\code{\link[=ui_epoxy_html]{ui_epoxy_html()}} call.
}
\description{
Server-side render function used to provide values for template items. Use
named values matching the template variable names in the associated
\code{\link[=ui_epoxy_html]{ui_epoxy_html()}} or \code{\link[=ui_epoxy_mustache]{ui_epoxy_mustache()}}. When the values are updated by
the app, \code{render_epoxy()} will update the values shown in the app's UI.
}
\section{Functions}{
\itemize{
\item \code{renderEpoxyHTML()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Deprecated alias,
please use \code{render_epoxy()}.

}}
\examples{
\dontshow{if (rlang::is_installed("shiny")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# This small app shows the current time using `ui_epoxy_html()`
# to provide the HTML template and `render_epoxy()` to
# update the current time every second.

ui <- shiny::fluidPage(
	shiny::h2("Current Time"),
	ui_epoxy_html(
		"time",
		shiny::p("The current time is {{strong time}}.")
	)
)

server <- function(input, output, session) {
	current_time <- shiny::reactive({
		shiny::invalidateLater(1000)
		strftime(Sys.time(), "\%F \%T")
	})

	output$time <- render_epoxy(time = current_time())
}

if (rlang::is_interactive()) {
	shiny::shinyApp(ui, server)
}
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
run_epoxy_example_app("render_epoxy")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=ui_epoxy_html]{ui_epoxy_html()}}, \code{\link[=ui_epoxy_mustache]{ui_epoxy_mustache()}}
}
