% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqMI.main.R
\name{eqMI.main}
\alias{eqMI.main}
\title{The main function to test measurement invariance}
\usage{
eqMI.main(
  ...,
  output = "both",
  equivalence.test = TRUE,
  adjRMSEA = TRUE,
  projection = FALSE,
  bootstrap = FALSE,
  quiet = TRUE,
  B = 100,
  seed = 111
)
}
\arguments{
\item{...}{The same arguments as for any lavaan model. See \code{lavaan::sem} for more information.

Users must explicitly specify the name of the input elements for this function to catch. For example, specify 'data = HolzingerSwineford' instead just 'HolzingerSwineford'.}

\item{output}{If the function prints out results of covariance structure, mean structure, or both. The value of \code{output} must be \code{mean}, \code{covariance}, or \code{both}. When the tests involve mean structure (\code{output = 'mean' or 'both'}), both the strong and the strict tests of measurement invariance will be conducted.}

\item{equivalence.test}{If \code{equivalence.test=TRUE}, equivalence testing is used for examining all statistics. RMSEA together with conventional or adjusted cutoff values will be used to gauge the goodness of fit.}

\item{adjRMSEA}{If \code{adjRMSEA=TRUE}, adjusted RMSEA cutoff values are used for equivalence testing. See details in Yuan & Chan (2016).}

\item{projection}{If \code{projection=TRUE}, projection method is used to test the equality of latent factor means. The advantage of the projection method over conventional multiple-group SEM approach is that the test of latent factor means can be conducted even when the equality of intercepts do not hold.}

\item{bootstrap}{If \code{bootstrap=TRUE}, bootstrap is used to obtain empirical p-values for testing the equality of cross-group latent factor means.}

\item{quiet}{If \code{quiet=FALSE}, a summary is printed out containing an overview of the different models that are fitted, together with some model comparison tests and fit measures. The results of equivalence testing will also be printed if equivalence testing is used. If \code{quiet=TRUE} (default), no summary is printed but results will be stored in 'AnnotatedOutput'.}

\item{B}{The number of boostrap samples used in bootstrap approach.}

\item{seed}{The initial seed to generate bootstrap samples. Default at 111.}
}
\value{
A list is returned with:
\describe{
\item{\code{AnnotatedOutput}}{Annotated outout that will be printed to the console if quiet==FALSE.}
\item{\code{eqMI.stat}}{Test statistics, degrees of freedom, p-values, ncp, T-sizes, RMSEAs, their cutoff values, and the goodness-of-fit under equivalence testing. A formated version of \code{eqMI.stat} will be printed if \code{quiet=FALSE}.}
\item{\code{convention.sem}}{Results of conventional multiple-group SEM using Lavaan. Returned object of \code{\link{eqMI.semtest}}.}
\item{\code{projection.res}}{Results of projection methods on tests of latent means. Returned object of \code{\link{eqMI.projection}} and \code{\link{eqMI.bootstrap}}.}
}
}
\description{
Test measurement invariance with equivalence testing, projection methods, and adjusted RMSEA cutoffs for two groups.
}
\details{
An all-in-one function with several added options to conduct a sequence of tests needed to evaluate MI. The chi-square statistics, except the one for testing the equality of covariance structure, are obtained based on \code{lavaan::sem} function. The test statistic of the covariance structure equality is obtained via the method of Lagrangian multiplier. Equivalence testing is enabled by setting \code{equivalence.test=TRUE} and this function will calculate T-size, RMSEA, and adjusted RMSEA cutoff values, and provide the goodness-of-fit.
}
\examples{
\donttest{
data(HolzingerSwineford)
semmodel<-'
L1 =~ V1 + V2 + V3
L2 =~ V4 + V5 + V6
L3 =~ V7 + V8
L4 =~ V9 + V10 + V11
'
# If raw data are available;

test <- eqMI.main(model = semmodel, data = HolzingerSwineford,
        group = "school", meanstructure = TRUE,
        output = 'both', quiet = FALSE,
        equivalence.test = TRUE, adjRMSEA = TRUE,
        projection = TRUE, bootstrap = FALSE)

# when only sample statistics are available;
# sample.cov need to be provided for tests of covariance structure;
# sample.mean need to be provided for tests of mean structure;

school1 <- subset(HolzingerSwineford, school==1)[,-12]
school2 <- subset(HolzingerSwineford, school==2)[,-12]
test <- eqMI.main(model = semmodel,
        sample.nobs = c(nrow(school1), nrow(school2)),
        sample.cov = list(cov(school1), cov(school2)),
        sample.mean = list(colMeans(school1), colMeans(school2)),
        meanstructure = TRUE, output = 'both', quiet = FALSE,
        equivalence.test = TRUE, adjRMSEA = TRUE,
        projection = TRUE, bootstrap = FALSE)
}
}
\references{
Deng, L., & Yuan, K. H. (2016). Comparing Latent Means Without Mean Structure Models: A Projection-Based Approach. Psychometrika, 81(3), 802-829. https://doi.org/10.1007/s11336-015-9491-8

Jiang, G., Mai, Y., & Yuan, K. H. (2017). Advances in Measurement Invariance and Mean Comparison of Latent Variables: Equivalence Testing and A Projection-Based Approach. Frontiers in Psychology, 8, 1823.

Yuan, K. H., & Chan, W. (2016). Measurement invariance via multigroup SEM: Issues and solutions with chi-square-difference tests. Psychological methods, 21(3), 405-426. https://doi.org/10.1037/met0000080
}
