% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqMI.ncp.R
\name{eqMI.ncp}
\alias{eqMI.ncp}
\title{Obtain noncentrality parameter of a chisquare distribution}
\usage{
eqMI.ncp(T, df, N, m, alpha = 0.05)
}
\arguments{
\item{T}{A chi-square statistic}

\item{df}{Degrees of freedom}

\item{N}{Total sample size of all groups}

\item{m}{Number of groups}

\item{alpha}{Significance level. Default at 0.05.}
}
\value{
The noncentrality parameter \code{ncp}, the minimum tolerable size \code{epsilon_t}, and \code{RMSEA_t} under equivalence testing.
}
\description{
Calculate the noncentrality parameter as well as the model missipecification epsilon_t given its lower-tail critical value.
}
\details{
This function is to compute the noncentrality parameter \code{ncp}, the model missipecification \code{epsilon_t}, and its corresponding \code{RMSEA_t}. With equivalence testing, the model missipecification is also the minimum tolerable size that a researcher needs to tolerate if one wishes to proceed with further restricted tests. The formula from Venables (1975) is used for obtaining the noncentrality parameter of a non-central chi-square distribution given its lower-tail critical value.
}
\examples{
alpha <- .05
n_1 <- 200
n_2 <- 200
N <- n_1 + n_2
m <- 2
# A made-up likelihood-ratio statistic
T_ml <- 8.824
df <- 6
ncp <- eqMI.ncp(T = T_ml, df = df, N = N, m = m, alpha = alpha)

}
\references{
Yuan, K. H., & Chan, W. (2016). Measurement invariance via multigroup SEM: Issues and solutions with chi-square-difference tests. Psychological methods, 21(3), 405-426.
}
