% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.ergm.ego.R
\name{simulate.ergm.ego}
\alias{simulate.ergm.ego}
\title{Simulate from a \code{\link{ergm.ego}} fit.}
\usage{
\method{simulate}{ergm.ego}(object, nsim = 1, seed = NULL,
  constraints = object$constraints, popsize = if (object$popsize == 1)
  object$ppopsize else object$popsize,
  control = control.simulate.ergm.ego(), output = c("network", "stats",
  "edgelist", "pending_update_network"), ..., verbose = FALSE)
}
\arguments{
\item{object}{An \code{\link{ergm.ego}} fit.}

\item{nsim}{Number of realizations to simulate.}

\item{seed}{Random seed.}

\item{constraints, \dots}{Additional arguments passed to \code{\link[ergm]{san}} and
\code{\link[ergm]{simulate.formula}}.}

\item{popsize}{Either network size to which to scale the model for
simulation or a \code{\link{data.frame}} with at least those ego attributes
required to estimate the model, to simulate over a specific set
of actors.}

\item{control}{A \code{\link{control.simulate.ergm.ego}} control list.}

\item{output}{one of \code{"network"}, \code{"stats"}, \code{"edgelist"}, or
\code{"pending_update_network"}. See help for \code{\link[=simulate.ergm]{simulate.ergm()}} for
explanation.}

\item{verbose}{Verbosity of output.}
}
\value{
The ouput has the same format (with the same options) as
\code{\link[ergm]{simulate.formula}}. If \code{output="stats"} is passed, an
additional attribute, \code{"ppopsize"} is set, giving the actual size of
the network reconstructed, when the \code{pop.wt} control parameter is set
to \code{"round"} and \code{"popsize"} is not a multiple of the egocentric
sample size or the sampling weights.
}
\description{
A wrapper around \code{\link[ergm]{simulate.formula}} to simulate networks
from an ERGM fit using \code{\link{ergm.ego}}.
}
\examples{

data(faux.mesa.high)
fmh.ego <- as.egodata(faux.mesa.high)
egofit <- ergm.ego(fmh.ego~edges+degree(0:3)+nodefactor("Race")+nodematch("Race")
               +nodefactor("Sex")+nodematch("Sex")+absdiff("Grade"), 
               popsize=network.size(faux.mesa.high))
colMeans(egosim <- simulate(egofit, popsize=300,nsim=50,
                       output="stats", control=control.simulate.ergm.ego(
                       simulate.control=control.simulate.formula(MCMC.burnin=2e6))))
colMeans(egosim)/attr(egosim,"ppopsize")*network.size(faux.mesa.high)
summary(faux.mesa.high~edges+degree(0:3)+nodefactor("Race")+nodematch("Race")
           +nodefactor("Sex")+nodematch("Sex")+absdiff("Grade"))

}
\references{
Pavel N. Krivitsky and Martina Morris. Inference for Social
Network Models from Egocentrically-Sampled Data, with Application to
Understanding Persistent Racial Disparities in HIV Prevalence in the US.
Thechnical Report. National Institute for Applied Statistics Research
Australia, University of Wollongong, 2015(05-15).
\doi{10.1214/16-AOAS1010}

Pavel N. Krivitsky, Mark S. Handcock, and Martina Morris. Adjusting for
Network Size and Composition Effects in Exponential-Family Random Graph
Models. \emph{Statistical Methodology}, 2011, 8(4), 319-339.
\doi{10.1016/j.stamet.2011.01.005}
}
\seealso{
\code{\link[ergm]{simulate.formula}},
\code{\link[ergm]{simulate.ergm}}
}
\author{
Pavel N. Krivitsky
}
\keyword{models}
