% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.mple.R, R/ergm.pl.R
\name{ergm.mple}
\alias{ergm.mple}
\alias{ergm.pl}
\title{Find a maximizer to the psuedolikelihood function}
\usage{
ergm.mple(
  nw,
  fd,
  m,
  init = NULL,
  MPLEtype = "glm",
  family = "binomial",
  save.xmat = TRUE,
  control = NULL,
  verbose = FALSE,
  ...
)

ergm.pl(
  nw,
  fd,
  m,
  theta.offset = NULL,
  control,
  ignore.offset = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{nw}{response \code{\link{network}} or \code{\link{ergm_state}}.}

\item{fd}{An \code{\link{rlebdm}} with informative dyads.}

\item{m}{the model, as returned by \code{\link{ergm_model}}}

\item{init}{a vector a vector of initial theta coefficients}

\item{MPLEtype}{the method for MPL estimation as "penalized", "glm"
or "logitreg"; default="glm"}

\item{family}{the family to use in the R native routine
\code{\link{glm}}; only applicable if "glm" is the 'MPLEtype';
default="binomial"}

\item{control}{A list of control parameters for algorithm tuning,
typically constructed with \code{\link[=control.ergm]{control.ergm()}}. Its documentation
gives the the list of recognized control parameters and their
meaning. The more generic utility \code{\link[=snctrl]{snctrl()}} (StatNet ConTRoL)
also provides argument completion for the available control
functions and limited argument name checking.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{\dots}{additional parameters passed from within; all will be
ignored}

\item{theta.offset}{a numeric vector of length equal to the number
of statistics of the model, specifying (positionally) the
coefficients of the offset statistics; elements corresponding to
free parameters are ignored.}

\item{ignore.offset}{If \code{FALSE} (the default), columns
corresponding to terms enclosed in \code{offset()} are not
returned with others but are instead processed by multiplying
them by their corresponding coefficients (which are fixed, by
virtue of being offsets) and the results stored in a separate
column.}
}
\value{
\code{ergm.mple} returns an ergm object as a list
containing several items; for details see the return list in the
\code{\link{ergm}}

\code{ergm.pl} returns a list containing:

\item{xmat}{the compressed and possibly sampled matrix of change
statistics}

\item{xmat.full}{as \code{xmat} but with offset terms}

\item{zy}{the corresponding vector of responses, i.e. tie values}

\item{foffset}{if \code{ignore.offset==FALSE}, the combined offset statistics multiplied by their parameter values}

\item{wend}{the vector of weights for \code{xmat}
and \code{zy}}
}
\description{
The \code{ergm.mple} function finds a maximizer to the psuedolikelihood
function (MPLE). It is the default method for finding the ERGM starting
coefficient values. It is normally called internally the ergm process and
not directly by the user. Generally \code{\link{ergmMPLE}} would be called
by users instead.

\code{ergm.pl} is an even more internal workhorse
function that prepares many of the components needed by
\code{ergm.mple} for the regression rountines that are used to
find the MPLE estimated ergm. It should not be called directly by
the user.
}
\details{
According to Hunter et al. (2008): "The maximizer of the pseudolikelihood
may thus easily be found (at least in principle) by using logistic
regression as a computational device." In order for this to work, the
predictors of the logistic regression model must be calculated.  These are
the change statistics as described in Section 3.2 of Hunter et al. (2008),
put into matrix form so that each pair of nodes is one row whose values are
the vector of change statistics for that node pair.  The ergm.pl function
computes these change statistics and the ergm.mple function implements the
logistic regression using R's glm function.  Generally, neither ergm.mple
nor ergm.pl should be called by users if the logistic regression output is
desired; instead, use the \code{\link{ergmMPLE}} function.

In the case where the ERGM is a dyadic independence model, the MPLE is the
same as the MLE.  However, in general this is not the case and, as van Duijn
et al. (2009) warn, the statistical properties of MPLEs in general are
somewhat mysterious.

MPLE values are used even in the case of dyadic dependence models as
starting points for the MCMC algorithm.
}
\references{
Hunter DR, Handcock MS, Butts CT, Goodreau SM, Morris and
Martina (2008).  "ergm: A Package to Fit, Simulate and Diagnose
Exponential-Family Models for Networks." \emph{Journal of Statistical Software},
\emph{24}(3), pp. 1-29. \doi{10.18637/jss.v024.i03}

van Duijn MAJ, Gile K, Handcock MS (2009).  "Comparison of Maximum Pseudo
Likelihood and Maximum Likelihood Estimation of Exponential Family Random
Graph Models." \emph{Social Networks}, \emph{31}, pp. 52-62.
}
\seealso{
\code{\link{ergmMPLE}},
\code{\link{ergm}},\code{\link{control.ergm}}
}
\keyword{internal}
