% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitWtErgmTerm.operator.R
\name{B-ergmTerm}
\alias{B-ergmTerm}
\alias{InitWtErgmTerm.B}
\title{Wrap binary terms for use in valued models}
\usage{
# valued: B(formula, form)
}
\arguments{
\item{formula}{a one-sided \code{\link[=ergm]{ergm()}}-style formula whose RHS contains the
binary ergm terms to be evaluated. Which terms may be used
depends on the argument \code{form}}

\item{form}{One of three values:
\itemize{
\item \code{"sum"}: see section "Generalizations of
binary terms" in \code{\link{ergmTerm}} help; all terms in \code{formula} must
be dyad-independent.
\item \code{"nonzero"}: section "Generalizations of
binary terms" in \code{\link{ergmTerm}} help; any binary \code{ergm} terms
may be used in \code{formula} .
\item a one-sided formula value-dependent
network. \code{form} must contain one "valued" \code{ergm} term, with
the following properties:
\itemize{
\item dyadic independence;
\item dyadwise contribution of either 0 or 1; and
\item dyadwise contribution of 0 for a 0-valued dyad.
}

Formally, this means that it is expressable as
\deqn{g(y) = \sum_{i,j} f_{i,j}(y_{i,j}),}{sum[i,j] f[i,j] (y[i,j]),}
where for all \eqn{i}, \eqn{j}, and \eqn{y},
\eqn{f_{i,j}(y_{i,j})} is either 0 or 1 and, in particular,
\eqn{f_{i,j}(0)=0}{f[i,j] (0)=0}.

Examples of such terms include \code{nonzero} ,
\code{ininterval()} , \code{atleast()} , \code{atmost()} ,
\code{greaterthan()} , \code{lessthen()} , and \code{equalto()} .

Then, the value of the statistic will be the value of the
statistics in \code{formula} evaluated on a binary network that is
defined to have an edge if and only if the corresponding
dyad of the valued network adds 1 to the valued term in
\code{form} .
}}
}
\description{
Wraps binary \code{ergm} terms for use in valued models, with \code{formula} specifying which terms
are to be wrapped and \code{form} specifying how they are to be
used and how the binary network they are evaluated on is to be constructed.
}
\details{
For example, \code{B(~nodecov("a"), form="sum")} is equivalent to
\code{nodecov("a", form="sum")} and similarly with
\code{form="nonzero"} .

When a valued implementation is available, it should be
preferred, as it is likely to be faster.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "B", "subsection")}
}
\concept{operator}
