% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{b2twostar-ergmTerm}
\alias{b2twostar-ergmTerm}
\alias{InitErgmTerm.b2twostar}
\title{Two-star census for central nodes centered on the second mode of a bipartite network}
\usage{
# binary: b2twostar(b1attr, b2attr, base=NULL, b1levels=NULL, b2levels=NULL, levels2=NULL)
}
\arguments{
\item{b1attr}{b1 nodes (actors in some contexts) (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details)}

\item{b2attr}{b2 nodes (events in some contexts). If \code{b1attr} is not passed, it is assumed to be the same as \code{b2attr} .}

\item{b1levels, b2levels, base, levels2}{used to leave some of the categories out (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details)}
}
\description{
This term is exactly the same as \code{b1twostar} except that the
roles of b1 and b2 are reversed.
}
\note{
The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{levels} are passed,
\code{levels} overrides \code{base}.

The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{levels2} are passed,
\code{levels2} overrides \code{base}.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b2twostar", "subsection")}
}
\concept{bipartite}
\concept{categorical nodal attribute}
\concept{undirected}
