% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.inCH.R
\name{shrink_into_CH}
\alias{shrink_into_CH}
\title{Identify the position of a point relative to the  convex hull of a set of points}
\usage{
shrink_into_CH(
  p,
  M,
  m = NULL,
  verbose = FALSE,
  ...,
  solver = c("glpk", "lpsolve")
)
}
\arguments{
\item{p}{a \eqn{d}-dimensional vector or a matrix with \eqn{d}
columns.}

\item{M}{an \eqn{n} by \eqn{d} matrix.  Each row of \code{M} is a
\eqn{d}-dimensional vector.}

\item{m}{a \eqn{d}-dimensional vector specifying the value towards
which to shrink; must be in the interior of the convex hull of
\eqn{M}, and defaults to its centroid (column means).}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{\dots}{arguments passed directly to linear program solver.}

\item{solver}{a character string selecting which solver to use; by
default, tries \code{Rglpk}'s but falls back to \code{lpSolveAPI}'s.}
}
\value{
Logical, telling whether \code{p} is (or all rows of
\code{p} are) in the closed convex hull of the points in
\code{M}.

The scaling factor described above is
returned. \code{shrink_into_CH() >= 1} indicates that all points in
\code{p} are in the convex hull of \code{M}.
}
\description{
This function uses linear programming to find the value by which
vector \code{p} needs to be scaled towards or away from vector \code{m} in
order for \code{p} to be on the boundary of the convex hull of rows of
\code{M}. If \code{p} is a matrix, a value that scales all rows of \code{p} into
the convex hull of \code{M} is found.
}
\note{
This is a successor to the deprecated function \code{is.inCH()}, which
was originally written for the "stepping" algorithm of Hummel et al
(2012). See Krivitsky, Kuvelkar, and Hunter (2022) for detailed
discussion of algorithms used in \code{is.inCH()} and
\code{shrink_into_CH()}.
}
\references{
\url{https://www.cs.mcgill.ca/~fukuda/soft/polyfaq/node22.html}

Hummel, R. M., Hunter, D. R., and Handcock, M. S. (2012), Improving
Simulation-Based Algorithms for Fitting ERGMs, \emph{Journal of
Computational and Graphical Statistics}, 21: 920-939.

Krivitsky, P. N., Kuvelkar, A. R., and Hunter,
D. R. (2022). Likelihood-based Inference for Exponential-Family
Random Graph Models via Linear Programming. \emph{arXiv preprint}
arXiv:2202.03572. \url{https://arxiv.org/abs/2202.03572}
}
\keyword{internal}
