% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-package.R
\name{ergmConstraint}
\alias{ergmConstraint}
\alias{ergm-constraints}
\alias{constraints-ergm}
\alias{ergm.constraints}
\alias{constraints.ergm}
\title{Sample Space Constraints for Exponential-Family Random Graph Models}
\description{
This page describes how to specify the constraints on the network sample space (the set of possible networks \eqn{Y}, the set of networks \eqn{y} for which \eqn{h(y)>0}) and sometimes the baseline weights \eqn{h(y)} to functions in the \code{\link[=ergm-package]{ergm}}
package. It also provides an indexed list of the constraints visible to the \CRANpkg{ergm}'s API. Constraints can also be searched via \code{\link{search.ergmConstraints}}, and help for an individual constraint can be obtained with \verb{ergmConstraint?<constraint>} or \code{help("<constraint>-ergmConstraint")}.
}
\section{Specifying constraints}{

\ERGMspec
Constraints typically affect \eqn{Y}, or, equivalently, set \eqn{h(y)=0} for some \eqn{y}, but some (\dQuote{soft} constraints) set
\eqn{h(y)} to values other than 0 and 1.

A constraints formula is a one- or two-sided formula whose left-hand side is
an optional direct selection of the \code{InitErgmProposal} function and
whose right-hand side is a series of one or more terms separated by
\code{"+"} and \code{"-"} operators, specifying the constraint.

The sample space (over and above the reference distribution) is determined
by iterating over the constraints terms from left to right, each term
updating it as follows:
\itemize{
\item If the constraint introduces complex
dependence structure (e.g., constrains degree or number of edges in the
network), then this constraint always restricts the sample space. It may
only have a \code{"+"} sign.
\item If the constraint only restricts the set of dyads that may vary in the
sample space (e.g., block-diagonal structure or fixing specific dyads at
specific values) and has a \code{"+"} sign, the set of dyads that may
vary is restricted to those that may vary according to this constraint
\emph{and} all the constraints to date.
\item If the constraint only restricts the set of dyads that may vary in the
sample space but has a \code{"-"} sign, the set of dyads that may
vary is expanded to those that may vary according to this constraint
\emph{or} all the constraints up to date.
}

For example, a constraints formula \code{~a-b+c-d} with all constraints
dyadic will allow dyads permitted by either \code{a} or \code{b} but only if they are
also permitted by \code{c}; as well as all dyads permitted by \code{d}. If \code{A}, \code{B},
\code{C}, and \code{D} were logical matrices, the matrix of variable dyads would be
equal to \code{((A|B)&C)|D}.

Terms with a positive sign can be viewed as "adding" a constraint
while those with a negative sign can be viewed as "relaxing" a constraint.

\subsection{Inheriting constraints from LHS \code{\link[network:network]{network}}}{

By default, \code{\link{\%ergmlhs\%}} attributes \code{constraints} or
\code{constraints.obs} (depending on which constraint) attached to the
LHS of the model formula or the \verb{basis=} argument will be added in
front of the specified constraints formula. This is the desired
behaviour most of the time, since those constraints are usually
determined by how the network was constructed (e.g., structural
zeros in a block-diagonal network).

For those situations in which this is not the desired behavior, a
\code{.} term (with a positive sign or no sign at all) can be used to
manually set the position of the inherited constraints in the
formula, and a \code{-.} (minus-dot) term anywhere in the constraints
formula will suppress the inherited formula altogether.

}
}

\section{Constraints visible to the package}{


\ergmCSS

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexLatex(ergm:::.buildTermsDataframe("ergmConstraint"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexText(ergm:::.buildTermsDataframe("ergmConstraint"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexHtml(ergm:::.buildTermsDataframe("ergmConstraint"))}}
\subsection{All constraints}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixLatex(ergm:::.termMatrix("ergmConstraint"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixText(ergm:::.termMatrix("ergmConstraint"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixHtml(ergm:::.termMatrix("ergmConstraint"))}}
}

\subsection{Constraints by keywords}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocLatex(ergm:::.termToc("ergmConstraint"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocText(ergm:::.termToc("ergmConstraint"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocHtml(ergm:::.termToc("ergmConstraint"))}}
}
}

\references{
\itemize{
\item Goodreau SM, Handcock MS, Hunter DR, Butts CT, Morris M (2008a).  A
\CRANpkg{statnet} Tutorial. \emph{Journal of Statistical Software}, 24(8).
\doi{10.18637/jss.v024.i08}
\item Hunter, D. R. and Handcock, M. S. (2006) \emph{Inference in curved
exponential family models for networks}, Journal of Computational and
Graphical Statistics.
\item Hunter DR, Handcock MS, Butts CT, Goodreau SM, Morris M (2008b).
\CRANpkg{ergm}: A Package to Fit, Simulate and Diagnose Exponential-Family
Models for Networks.  \emph{Journal of Statistical Software}, 24(3).
\doi{10.18637/jss.v024.i03}
\item Karwa V, Krivitsky PN, and Slavkovi\'c AB (2016). Sharing Social Network
Data: Differentially Private Estimation of Exponential-Family Random Graph
Models. \emph{Journal of the Royal Statistical Society, Series C}, 66(3):
481-500. \doi{10.1111/rssc.12185}
\item Krivitsky PN (2012). Exponential-Family Random Graph Models for Valued
Networks. \emph{Electronic Journal of Statistics}, 6, 1100-1128.
\doi{10.1214/12-EJS696}
\item Morris M, Handcock MS, Hunter DR (2008).  Specification of
Exponential-Family Random Graph Models: Terms and Computational Aspects.
\emph{Journal of Statistical Software}, 24(4). \doi{10.18637/jss.v024.i04}
}
}
\keyword{models}
