% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.utils.R
\name{ergm_state_cache}
\alias{ergm_state_cache}
\title{A rudimentary cache for large objects}
\usage{
ergm_state_cache(
  comm = c("pass", "all", "clear", "insert", "get", "check", "list"),
  key,
  object
)
}
\arguments{
\item{comm}{a character string giving the desired function; see the
default argument above for permitted values and Details for
meanings; partial matching is supported.}

\item{key}{a character string, typically a \code{digest::digest()} of
the object or a random string.}

\item{object}{the object to be stored.

Supported tasks are, respectively, to do nothing (the default),
return all entries (mainly useful for testing), clear the cache,
insert into cache, retrieve an object by key, check if a key is
present, or list keys defined.

Deleting an entry can be accomplished by inserting a \code{NULL} for
that key.

Cache is limited to a hard-coded size (currently 4). This should
accommodate an \code{\link{ergm_model}} and an \code{\link{ergm_proposal}} for
unconstrained and constrained MCMC. When additional objects are
stored, the oldest object is purged and garbage-collected.}
}
\description{
This cache is intended to store large, infrequently changing data
structures such as \code{\link{ergm_model}}s and \code{\link{ergm_proposal}}s on worker
nodes.
}
\note{
If called via, say, \code{clusterMap(cl, ergm_state_cache, ...)}
the function will not accomplish anything. This is because
\code{parallel} package will serialise the \code{ergm_state_cache()}
function object, send it to the remote node, evaluate it there,
and fetch the return value. This will leave the environment of
the worker's \code{ergm_state_cache()} unchanged. To actually
evaluate it on the worker nodes, it is recommended to wrap it in
an empty function whose environment is set to \code{\link[=globalenv]{globalenv()}}. See
Examples below.
}
\examples{
\dontrun{
# Wrap ergm_state_cache() and call it explicitly from ergm:
call_ergm_state_cache <- function(...) ergm::ergm_state_cache(...)

# Reset the function's environment so that it does not get sent to
# worker nodes (who have their own instance of ergm namespace
# loaded).
environment(call_ergm_state_cache) <- globalenv()

# Now, call the the wrapper function, with ... below replaced by
# lists of desired arguments.
clusterMap(cl, call_ergm_state_cache, ...)
}

}
