% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulae.R
\name{ergmito_formulae}
\alias{ergmito_formulae}
\alias{ergmito_loglik}
\title{Processing formulas in \code{ergmito}}
\usage{
ergmito_formulae(
  model,
  gattr_model = NULL,
  target.stats = NULL,
  stats.weights = NULL,
  stats.statmat = NULL,
  env = parent.frame(),
  ...
)
}
\arguments{
\item{model}{A formula. The left-hand-side can be either a small network, or
a list of networks.}

\item{gattr_model}{A formula. Model specification for graph attributes. This
is useful when using multiple networks.}

\item{target.stats}{Observed statistics. If multiple networks, then a list, otherwise
a named vector (see \link[ergm:summary_formula]{ergm::summary_formula}).}

\item{stats.weights, stats.statmat}{Lists of sufficient statistics and their
respective weights.}

\item{env}{Environment in which \code{model} should be evaluated.}

\item{...}{Further arguments passed to \link[ergm:ergm.allstats]{ergm::ergm.allstats}.}
}
\value{
A list of class \code{ergmito_loglik}.
\itemize{
\item \code{loglik} A function. The log-likelihood function.
\item \code{grad} A function. The gradient of the model.
\item \code{stats.weights},\code{stats.statmat} two list of objects as returned by
\link[ergm:ergm.allstats]{ergm::ergm.allstats}.
\item \code{model} A formula. The model passed.
\item \code{npars} Integer. Number of parameters.
\item \code{nnets} Integer. Number of networks in the model.
\item \code{vertex.attr} Character vector. Vertex attributes used in the model.
\item \code{term.names} Names of the terms used in the model.
}
}
\description{
Analyze formula objects returning the matrices of weights and sufficient
statistics to be used in the model together with the log-likelihood and
gradient functions for joint models.
}
\examples{
data(fivenets)
model <- ergmito_formulae(fivenets ~ edges + nodematch("female"))
print(model)
model$loglik(c(-2, 2))
}
