% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{matrix_to_network}
\alias{matrix_to_network}
\alias{matrix_to_network.matrix}
\alias{matrix_to_network.list}
\title{Manipulation of network objects}
\usage{
matrix_to_network(
  x,
  directed = rep(TRUE, length(x)),
  hyper = rep(FALSE, length(x)),
  loops = rep(FALSE, length(x)),
  multiple = rep(FALSE, length(x)),
  bipartite = rep(FALSE, length(x))
)

\method{matrix_to_network}{matrix}(
  x,
  directed = rep(TRUE, length(x)),
  hyper = rep(FALSE, length(x)),
  loops = rep(FALSE, length(x)),
  multiple = rep(FALSE, length(x)),
  bipartite = rep(FALSE, length(x))
)

\method{matrix_to_network}{list}(
  x,
  directed = rep(TRUE, length(x)),
  hyper = rep(FALSE, length(x)),
  loops = rep(FALSE, length(x)),
  multiple = rep(FALSE, length(x)),
  bipartite = rep(FALSE, length(x))
)
}
\arguments{
\item{x}{Either a single square matrix (adjacency matrix), or a list of these.}

\item{directed}{Logical scalar, if \code{FALSE} then the function only checks the
upper diagonal of the matrix assuming it is undirected.}

\item{hyper, multiple, bipartite}{Currently Ignored. Right now all the network objects
created by this function set these parameters as \code{FALSE}.}

\item{loops}{Logical scalar. When \code{FALSE} (default) it will skip the diagonal
of the adjacency matrix.}
}
\value{
An object of class \code{network}. This is a list with the following elements:
\itemize{
\item \code{mel} \emph{Master Edge List}: A named list with length equal to the number of edges in
the network. The list itself has 3 elements: \code{inl} (tail), \code{outl} (head), and
\code{atl} (attribute). By default \code{atl}, a list itself, has a single element: \code{na}.
\item \code{gal} \emph{Graph Attributes List}: a named list with the following elements:
\itemize{
\item \code{n} Number of nodes
\item \code{mnext} Number of edges + 1
\item \code{directed},\code{hyper},\code{loops},\code{multiple},\code{bipartite} The arguments passed to
the function.
}
\item \code{val} \emph{Vertex Attributes List}
\item \code{iel} \emph{In Edgest List}
\item \code{oel} \emph{Out Edgest List}
}
}
\description{
This function implements a vectorized version of \link[network:network]{network::network}\code{.adjmat}.
It allows us to turn regular matrices into network objects quickly.
}
\details{
This version does not support adding the name parameter yet. The
function in the network package includes the name of the vertices as an
attribute.

Just like in the network function, \code{NA} are checked and added accordingly, i.e.
if there is an \code{NA} in the matrix, then the value is recorded as a missing edge.
}
\examples{
set.seed(155)
adjmats  <- rbernoulli(rep(5, 20))
networks <- matrix_to_network(adjmats)

}
