% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergmito-checkers.R
\name{check_support}
\alias{check_support}
\alias{check_convergence}
\title{Check the convergence of ergmito estimates}
\usage{
check_support(target.stats, stats.statmat, threshold = 0.8, warn = TRUE)

check_convergence(optim_output, model, support, crit = 5)
}
\arguments{
\item{target.stats, stats.statmat}{See \link{ergmito_formulae}.}

\item{threshold}{Numeric scalar. Confidence range for flagging an observed
statistic as potentially near the boundary.}

\item{warn}{logical scalar.}

\item{optim_output}{A list output from the \link[stats:optim]{stats::optim} function.}

\item{model}{An object of class \link{ergmito_loglik}.}

\item{support}{As returned by \code{check_support}.}

\item{crit}{Numeric scalar. Level at which a parameter estimate
will be questioned.}
}
\value{
A list with the following components:
\itemize{
\item \code{par} Updated set of parameters
\item \code{vcov} Updated variance-covariance matrix
\item \code{valid} Vector of integers with the parameters that are marked as OK.
\item \code{status} Return code of the analysis. See details.
\item \code{note} A note describing the status.
}
}
\description{
This is an internal function used to check the convergence of the optim function.
}
\section{Return codes}{


The function makes an analysis of the outcome of the model and makes the corresponding
adjustments when required. In particular, we check:
\enumerate{
\item Whether the optimization algorithm converged or not
\item If the obtained estimates maximize the function. If this is not the case,
the function checks whether the MLE may not exist. This usually happens
when the log-likelihood function can improve by making increments to parameters
that are already tagged as large. If the ll improves, then the value is
replaced with \code{Inf} (+- depending on the sign of the parameter).
\item If the Hessian is semi-positive-definite, i.e. if it is invertible. If it
is not, it usually means that the function did not converged, in which
case we will use \link[MASS:ginv]{MASS::ginv} instead.
}

The return codes are composed of two numbers, the first number gives information
regarding of the parameter estimates, while the second number give information
about the variance-covariance matrix.

Column 1:
\itemize{
\item 0: Converged and estimates at the max.
\item 1: It did not converged, but I see no issue in the max.
\item 2: One or more estimates went to +/-Inf
\item 3: All went to hell. All estimates went to +/-Inf
}

Column 2:
\itemize{
\item 0: Hessian is p.s.d.
\item 1: Hessian is not not p.s.d.
}

Possible codes and corresponding messages:
\itemize{
\item 00 All OK (no message).
\item 01 \Sexpr{ergmito:::map_convergence_message(01)}. \% Convergence, but the hessian is not psd
\item 10 \Sexpr{ergmito:::map_convergence_message(10)}. \% Optim did not reported convergence, but things look OK.
\item 11 \Sexpr{ergmito:::map_convergence_message(11)}. \% Optim did not converged, but the hessian is not psd.
\item 20 \Sexpr{ergmito:::map_convergence_message(20)}. \% One or more estimates went to inf, all finite were able to be inverted.
\item 21 \Sexpr{ergmito:::map_convergence_message(21)}. \% One or more are inf, hessian is not psd
\item 30 \Sexpr{ergmito:::map_convergence_message(30)}. \% All estimates went to Inf (degenerate distribution).
}
}

\keyword{Internal}
