% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTrees.R
\name{CompareTrees}
\alias{CompareTrees}
\title{Compare two tree structures}
\usage{
CompareTrees(tree_test, tree_ref)
}
\arguments{
\item{tree_test}{(testing tree) a tree structure in the form of nested lists (as the output of hclust2tree, for example)}

\item{tree_ref}{(reference tree) a tree structure in the form of nested lists (as the output of hclust2tree, for example)}
}
\value{
boolean: TRUE implies that the two trees are equivalent.
}
\description{
Provide a logical answer to the question "Are two trees equivalent?".
}
\details{
This test is particularly useful when two trees are not ordered in the same way.
As the structure are lists, one could argue that this function is a modification
of the \code{\link{identical}} base function, overcoming the ordering.
}
\examples{
## Comparison between "identical" and "compareTrees"
##
## The trees are "identical"

tree1 <- list(list(list(5, 6), list(7, 8), 3, 4), list(9, 10), 2, 1)
tree2 <- list(list(list(5, 6), list(7, 8), 3, 4), list(9, 10), 2, 1)

CompareTrees(tree1, tree2)
identical(tree1, tree2)

## The trees are "equivalent" (notice the leaves 1 and 2 interchanged)

tree1 <- list(list(list(5, 6), list(7, 8), 3, 4), list(9, 10), 2, 1)
tree2 <- list(list(list(5, 6), list(7, 8), 3, 4), list(9, 10), 1, 2)

CompareTrees(tree1, tree2)
identical(tree1, tree2)

}
\author{
Simon-Pierre Gadoury
}
