% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_diagnostic_ww}
\alias{plot_diagnostic_ww}
\title{Diagnostic plot for R estimation from wastewater data}
\usage{
plot_diagnostic_ww(r.estim, caption = NULL)
}
\arguments{
\item{r.estim}{List. Output of \code{\link[=estimate_R_ww]{estimate_R_ww()}}.}

\item{caption}{Character. Optional plot caption.}
}
\value{
A \code{ggplot} object.
}
\description{
Diagnostic plot for R estimation from wastewater data
}
\examples{

# Load data of viral concentration in wastewater
data("ww.input")

# Estimate Rt based on wastewater data
x = estimate_R_ww(
  ww.conc  = ww.input,
  dist.fec = def_dist_fecal_shedding(pathogen = 'sarscov2'),
  dist.gi  = def_dist_generation_interval(pathogen = 'sarscov2'), 
  silent   = TRUE
)

# Diagnostic plot
g = plot_diagnostic_ww(x)
plot(g)


}
\seealso{
\code{\link[=estimate_R_ww]{estimate_R_ww()}} \code{\link[=plot_diagnostic_cl]{plot_diagnostic_cl()}}
}
