% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_crop.R
\name{spatial_crop}
\alias{spatial_crop}
\title{Crop extent of spatial data.}
\usage{
spatial_crop(data, bbox)
}
\arguments{
\item{data}{\code{raster} object, spatial data set to be processed.}

\item{bbox}{\code{Numeric} vector of length four, bounding box coordinates 
in the form \code{c(xmin, xmax, ymin, ymax)}}
}
\value{
spatial object, cropped to bounding box
}
\description{
The function crops the spatial extent of raster objects or other 
spatial objects based on bounding box coordinates.
}
\examples{

## create example data set
x <- terra::rast(nrows = 100, ncols = 100, 
                 xmin = 0, xmax = 10, 
                 ymin = 0, ymax = 10)
terra::values(x) <- 1:10000

## create crop extent vector
bbox <- c(3, 7, 3, 7)

## crop spatial object
y <- spatial_crop(data = x, 
                  bbox = bbox)

## plot both objects
terra::plot(x)
terra::plot(y, add = TRUE)

}
\author{
Michael Dietze
}
\keyword{eseis}
