% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_clip.R
\name{signal_clip}
\alias{signal_clip}
\title{Clip signal based on time vector.}
\usage{
signal_clip(data, limits, time)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{limits}{\code{POSIXct} vector of length two, time limits for 
clipping. Can also be a text string that will be converted to POSIXct
format, with UTC assigned automatically.}

\item{time}{\code{POSIXct} vector, corresponding time vector. Only needed 
if \code{data} is no \code{eseis} object.}
}
\value{
\code{Numeric} data set clipped to provided time interval.
}
\description{
The function clips a seismic signal based on the corresponding time vector.
}
\examples{

## load example data
data(rockfall)

## define limits (second 10 to 20 of the signal)
limits <- c(rockfall_t[1] + 10, rockfall_t[1] + 20)

## clip signal 
rockfall_clip <- signal_clip(data = rockfall_z, 
                             time = rockfall_t, 
                             limits = limits)
                     
## clip signal using the eseis object
rockfall_clip <- signal_clip(data = rockfall_eseis, 
                             limits = limits)
                             
}
\author{
Michael Dietze
}
\keyword{eseis}
