% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingEndDateTime.R
\name{missingEndDateTime}
\alias{missingEndDateTime}
\title{missingEndDateTime}
\usage{
missingEndDateTime(esDf, RELEVANTVN_ES = NULL)
}
\arguments{
\item{esDf}{a data.frame. A single ESM dataset. It must contain the 2 columns that hold the date-time object for when an ESM questionnaire was started and finished, respectively.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}
}
\value{
\code{esDf} with the additional columns NOENDDATE and NOENDTIME. See \strong{Details} for more information
}
\description{
missingEndDateTime registers all ESM questionnaires with a missing time stamp of when they were finished.
}
\details{
Both new columns are dummy variables: 1 = true = end date/end time is missing, 0 = false = end date/end time is present.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute missingEndDateTime. Start -------
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
# esAssigned is a list of datasets, delivered with the package. It is
# the result of the assignment of the ESM questionnaires to ALL 8
# participants in the reference dataset.
# Prerequisites in order to execute missingEndDateTime. End ---------
# -------------------------------------------------------
# Run function 17 of 28; see esmprep functions' hierarchy.
# -------------------------------------------------------
# esAssigned[["ES"]] is one of the results of function 'esAssign'.
noEndDf <- missingEndDateTime(esAssigned[["ES"]], RELEVANTVN_ES)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 17 of 28).
}
