% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printRmInvalid.R
\name{printRmInvalid}
\alias{printRmInvalid}
\title{printRmInvalid}
\usage{
printRmInvalid(rmInvalidList, RELEVANTVN_ES = NULL, smr = "tabulate")
}
\arguments{
\item{rmInvalidList}{a list. Pass the result obtained from function \code{rmInvalid} as argument.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}

\item{smr}{a character string. Specify the level of detail you want to be displayed in the console. There are 3 options. The default option is 'tabulate', which displays a table, indicating the number of removed questionnaires for each ESM version. The next option is 'detail', which displays the entire removed questionnaires. The last option is 'both', which displays both the table and the detailed information.}
}
\value{
In addition to the information the user wants to be displayed (see argument \code{smr}), the function returns a list containing the KEY value (see function \code{\link{genKey}}) of all the questionnaires that have been removed from each of the raw ESM datasets.
}
\description{
printRmInvalid prints to the console the lines that were registered to be invalid in the raw ESM dataset.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute printRmInvalid. Start -----------
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
# keyLsNew is a list of datasets, also delivered with the package
rmInvLs <- rmInvalid(keyLsNew, RELEVANTVN_ES)
# Prerequisites in order to execute printRmInvalid. End -------------
# ------------------------------------------------------
# Run function 9 of 28; see esmprep functions' hierarchy.
# ------------------------------------------------------
# rmInvLs is the result of function 'rmInvalid'. Display its result
# in the console both tablulated and in detail.
key_rmLs <- printRmInvalid(rmInvLs, smr="both", RELEVANTVN_ES)
# Display the list containing the KEY values of all questionnaires
# that have been removed.
key_rmLs
# Since there have been warning messages in 4 of the 6 datasets,
# the first ESM item (name: V1) was automatically converted to class
# character, although it is numeric. So we'll re-convert V1's class.
# Check V1 prior to conversion
str(rmInvLs[["dfValid"]][[2]][1:2])
rmInvLs[["dfValid"]] <- sapply(rmInvLs[["dfValid"]], function(x) {
     x[,"V1"] <- as.numeric(x[,"V1"])
     return(x) } )
# Check V1 after conversion
str(rmInvLs[["dfValid"]][[2]][1:2])
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 9 of 28).
}
