% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmInvalid.R
\name{rmInvalid}
\alias{rmInvalid}
\title{rmInvalid}
\usage{
rmInvalid(dfList, RELEVANTVN_ES = NULL)
}
\arguments{
\item{dfList}{a list. Each element of the list must be a data.frame. Each data.frame is a separate raw ESM dataset/an ESM questionnaire version. If there is just one ESM version the list therefore contains one data.frame.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}
}
\value{
The user receives a list containing 4 elements:
\enumerate{
\item dfValid, i.e. the raw ESM dataset(s), after removing all invalid lines of data.
\item listInvalid, i.e. the raw ESM dataset(s), containing only the removed lines of data.
\item rmInvalidFinished, i.e. a logical value, specifying whether at least one line of data was removed due to being invalid.
\item noLinesRemovedAtAll, i.e. a logical vector, specifying in which of the ESM raw dataset(s) there were invalid lines of data.
}
See \strong{Details} for more information.
}
\description{
removeInvalid removes the invalid ESM questionnaires as specified by the user.
}
\details{
A data line is assumed to be invalid if both the start date and the start time are missing (NA = not available).
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute rmInvalid. Start ----------------
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
# keyLsNew is a list of datasets, also delivered with the package
# Prerequisites in order to execute rmInvalid. End ------------------
# ------------------------------------------------------
# Run function 8 of 28; see esmprep functions' hierarchy.
# ------------------------------------------------------
# keyLsNew is the result of function 'genDateTime' (or of function 'splitDateTime').
rmInvLs <- rmInvalid(keyLsNew, RELEVANTVN_ES)
# Result of function 'rmInvalid' is a list with 4 elements:
names(rmInvLs)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 8 of 28).
}
