% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dicom_tag_dictionary.R
\name{dicom.tag.dictionary}
\alias{dicom.tag.dictionary}
\title{DICOM TAG dictionary}
\usage{
dicom.tag.dictionary(add.dict = c("raysearch.tag"))
}
\arguments{
\item{add.dict}{Vector of the list of additional dictionaries. Put to NULL, if
no additional dictionary is requested.}
}
\value{
Returns a 3-column dataframe, describing the VR (value representation)
and the name of each DICOM TAG.

This dataframe is the fusion of the "nema.tag" dictionary, provided
by \emph{nema} \strong{[1]}, with the dictionaries defined in the
\code{add.dict} vector:
\itemize{
\item "raysearch.tag" dictionary is provided by \emph{RaySearch laboratories} \strong{[2]}
}
}
\description{
The \code{dicom.tag.dictionary} function gives the dictionary of
tags used by default in the \pkg{espadon} package.
}
\examples{
str (dicom.tag.dictionary ())
str (dicom.tag.dictionary (NULL))
}
\references{
\strong{[1]} \insertRef{nema}{espadon}

\strong{[2]} \insertRef{raysearch}{espadon}
}
