% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{module-filterDF}
\alias{module-filterDF}
\alias{filterDF_UI}
\alias{filterDF}
\title{Shiny module to interactively filter a \code{data.frame}}
\usage{
filterDF_UI(id, show_nrow = TRUE)

filterDF(
  input,
  output,
  session,
  data_table = reactive(),
  data_vars = shiny::reactive(NULL),
  data_name = reactive("data"),
  label_nrow = "Number of rows:",
  drop_ids = TRUE,
  picker = FALSE
)
}
\arguments{
\item{id}{Module id. See \code{\link[shiny]{callModule}}.}

\item{show_nrow}{Show number of filtered rows and total.}

\item{input, output, session}{standards \code{shiny} server arguments.}

\item{data_table}{\code{\link[shiny]{reactive}} function returning a
\code{data.frame} to filter.}

\item{data_vars}{\code{\link[shiny]{reactive}} function returning a
\code{character} vector of variable to use for filters.}

\item{data_name}{\code{\link[shiny]{reactive}} function returning a
\code{character} string representing \code{data_table} name.}

\item{label_nrow}{Text to display before the number of rows of filtered data / source data.}

\item{drop_ids}{Drop columns containing more than 90\% of unique values, or than 50 distinct values.}

\item{picker}{Use  \code{\link[shinyWidgets:pickerInput]{shinyWidgets::pickerInput}}
instead of  \code{\link[shiny:selectInput]{shiny::selectizeInput}} (default).}
}
\value{
A \code{list} with 2 elements :
\itemize{
\item \strong{data_filtered} : \code{\link[shiny]{reactive}} function returning data filtered.
\item \strong{code} : \code{\link[shiny]{reactiveValues}} with 2 slots :
\code{expr} (raw expression to filter data) and \code{dplyr} (code with dplyr pipeline).
}
}
\description{
DEPRECATED, please see package \href{https://github.com/dreamRs/datamods}{datamods} for similar features.
}
