% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive.R
\name{mmd}
\alias{mmd}
\title{Naive computation for Maximum Mean Discrepancy}
\usage{
mmd(
  X,
  Y,
  beta = -0.1,
  pval = TRUE,
  kernel = c("Laplacian", "Gaussian"),
  numperm = 200,
  seednum = 0
)
}
\arguments{
\item{X}{Matrix (or vector) of observations in first sample.}

\item{Y}{Matrix (or vector) of observations in second sample.}

\item{beta}{kernel parameter. Must be positive; if not, computes
median heuristic in quadratic time. Default value
is \code{-0.1}, which will force median heuristic to be used.}

\item{pval}{Boolean for whether to compute p-value or not.}

\item{kernel}{String, either \code{"Laplacian"} or \code{"Gaussian"}.
Default is \code{"Laplacian"}.}

\item{numperm}{Number of permutations. Default is \code{200}.}

\item{seednum}{Seed number for generating permutations. Default is \code{0},
which means seed is set randomly. For values larger than
\code{0}, results will be reproducible.}
}
\value{
A list with the following elements:
\describe{
\item{\code{pval}}{The p-value of the test, if it is
computed (\code{pval=TRUE}). }
\item{\code{stat}}{The statistic of the test, which
is always computed. }
\item{\code{beta}}{The kernel parameter used in the test.
If \code{beta} was not initialised or
negative, this will be the median heuristic
value.}
}
}
\description{
Computes maximum mean discrepancy statistics with Laplacian
or Gaussian kernel.
Suitable for multivariate data. Naive approach, quadratic in number
of observations.
}
\details{
First checks number of columns (dimension) are equal.
Suppose matrix \code{X} has \code{n} rows and \code{d} columns,
and matrix \code{Y} has \code{m} rows; checks that \code{Y}
has \code{d} columns (if not, then throws error).
Then flattens matrices to vectors (or, if \code{d=1}, they are
already vectors.
Then calls C++ method. If the first sample has \code{n}
\code{d}-dimensional samples and the second sample has
\code{m} \code{d}-dimensional samples, then the algorithm
computes the statistic in \code{O( (n+m)^2 )} time.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     Median difference is as follows:
}\if{html}{\out{</div>}}

\code{ m = median { ||x_i - x_j||_1; i=1, 2, ..., n+m, and j=1, 2,..., i } },

\if{html}{\out{<div class="sourceCode">}}\preformatted{     where \code{||x_i - x_j||_1} is the 1-norm, and so if the data 
     are \code{d}-dimensional then
     
     \code{ ||x_i - x_j||_1 = \sum_{k=1}^{d} |x_{i,k} - x_{j,k}| },
     
     and finally median heuristic is \code{beta = 1/m}.
     This can be computed in \code{O( (n+m)^2 )} time.
     NOTE: fix.
     
     The Laplacian kernel \code{k} is defined as 
    
     \code{ k(x,y) = \exp( -\beta ||x - y||_1  ) }.

     Random seed is set for \code{std::mt19937} and \code{std::shuffle} 
     in C++.
}\if{html}{\out{</div>}}
}
\examples{

X <- matrix(c(1:12), ncol=2, byrow=TRUE)
Y <- matrix(c(13:20), ncol=2, byrow=TRUE)
mmdList <- mmd(X=X, Y=Y, beta=0.1, pval=FALSE)


}
