% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion_measures.R
\name{ebc_TP}
\alias{ebc_TP}
\alias{ebc_FP}
\alias{ebc_FN}
\alias{ebc_TN}
\title{Confusion measures.}
\usage{
ebc_TP(detected, true)

ebc_FP(detected, true)

ebc_FN(detected, true)

ebc_TN(detected, true, all, m = length(all))
}
\arguments{
\item{detected}{Vector of elements that are detected.}

\item{true}{Vector of element that are supposed to be detected.}

\item{all}{Vector of all elements.}

\item{m}{Total number of elements.}
}
\value{
An integer.
}
\description{
Basic measures from the confusion matrix.
}
\details{
See \code{\link{ebc_allmeasures}} for the description of the measures.
}
\examples{
ebc_TP(detected = c("A", "C", "D"), true = c("A", "B", "C"))
ebc_FP(detected = c("A", "C", "D"), true = c("A", "B", "C"))
ebc_FN(detected = c("A", "C", "D"), true = c("A", "B", "C"))
ebc_TN(detected = c("A", "C", "D"), true = c("A", "B", "C"),
       all = LETTERS[1:6])
ebc_TN(detected = c("A", "C", "D"), true = c("A", "B", "C"), m = 6)
}
\seealso{
\code{\link{ebc_TPR}}, \code{\link{ebc_tidy}},
\code{\link{ebc_allmeasures}}
}
