% Please edit documentation in R/parse.r
\name{parse_all}
\alias{parse_all}
\title{Parse, retaining comments.}
\usage{
parse_all(x, filename = NULL, allow_error = FALSE)
}
\arguments{
\item{x}{object to parse.  Can be a string, a file connection, or a function}

\item{filename}{string overriding the file name}

\item{allow_error}{whether to allow syntax errors in \code{x}}
}
\value{
A data.frame with columns \code{src}, the source code, and
  \code{expr}. If there are syntax errors in \code{x} and \code{allow_error =
  TRUE}, the data frame has an attribute \code{PARSE_ERROR} that stores the
  error object.
}
\description{
Works very similarly to parse, but also keeps original formatting and
comments.
}
