% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_max_losses}
\alias{calculate_max_losses}
\title{Calculate maximum losses}
\usage{
calculate_max_losses(simulation_results, scenario_outliers = NULL)
}
\arguments{
\item{simulation_results}{Simulation results dataframe.}

\item{scenario_outliers}{Optional vector of IDs of outlier scenarios.}
}
\value{
A dataframe with the following columns:
\itemize{
\item \code{iteration} - index of the iteration
\item \code{biggest_single_scenario_loss} - the biggest annual loss in that iteration,
\item \code{min_loss} - the smallest annual loss in that iteration,
\item \code{max_loss} - the total annual losses in that iteration
\item \code{outliers} - logical of whether or not outliers are included
}
}
\description{
Calculate the biggest single annual loss for each scenario, as well as
the minimum and maximum ALE across all iterations. Calculations both
with and without outliers (if passed) are returned.
}
\examples{
data(mc_simulation_results)
calculate_max_losses(mc_simulation_results)
}
