% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictEnrollment.R
\name{predictEnrollment}
\alias{predictEnrollment}
\title{Predict enrollment}
\usage{
predictEnrollment(
  df = NULL,
  target_n,
  enroll_fit,
  lags = 30,
  pilevel = 0.9,
  nreps = 500,
  showplot = TRUE
)
}
\arguments{
\item{df}{The subject-level enrollment data, including
\code{randdt} and \code{cutoffdt}. By default, it is set to
\code{NULL} for enrollment prediction at the design stage.}

\item{target_n}{The target number of subjects to enroll in the study.}

\item{enroll_fit}{the pre-fitted enrollment model used to
generate predictions.}

\item{lags}{The day lags to compute the average enrollment rate to
carry forward for the B-spline enrollment model. By default,
it is set to 30.}

\item{pilevel}{The prediction interval level. By default,
it is set to 0.90.}

\item{nreps}{The number of replications for simulation. By default,
it is set to 500.}

\item{showplot}{A Boolean variable to control whether or not
the prediction plot is displayed. By default, it is set to
\code{TRUE}.}
}
\value{
A list of prediction results, which includes important information
such as the median, lower and upper percentiles for the estimated
time to reach the target number of subjects, as well as simulated
enrollment data for new subjects. Additionally, the data for the
prediction plot is also included within the list.
}
\description{
Utilizes a pre-fitted enrollment model to generate
enrollment times for new subjects and also provide a prediction
interval for the expected time to reach the enrollment target.
}
\details{
The \code{enroll_fit} variable can be used for enrollment
prediction at the design stage. A piecewise Poisson enrollment
model can be parameterized through the time intervals,
\code{accrualTime}, and the enrollment rates in the intervals,
\code{accrualIntensity}. These are treated as fixed for
design-stage enrollment prediction.
For the homogeneous Poisson and time-decay models,
\code{enroll_fit} is used to specify the prior distribution of
model parameters, with a very small variance being used to fix
the parameter values. It should be noted that the B-spline model
is not appropriate for use during the design stage.
}
\examples{

# Enrollment prediction at the design stage

enroll_pred <- predictEnrollment(
  target_n = 400,
  enroll_fit = list(model = "piecewise poisson",
                    accrualTime = seq(0, 8)*30.4375,
                    accrualIntensity = 26/9*seq(1, 9)/30.4375),
  pilevel = 0.90, nreps = 200)


}
