% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_handler.R
\name{add_handler}
\alias{add_handler}
\title{Add Handler}
\usage{
add_handler(obj, .handler)
}
\arguments{
\item{obj}{A handler, handler_list or dispatcher object.}

\item{.handler}{A handler object.}
}
\value{
Retun a \code{handlers_list} object.
}
\description{
Merge two handler objects or add a handler in a handlers_list or dispatcher objects.
}
\examples{

library(eventr)
library(magrittr)

birth_handler <- handler(type = 'BIRTH', FUN = function(obj, event){
  obj$birth_date <- get_body_attr(event, 'birth_date')
  return(obj)
})

measurement_handler <- handler(type = 'MEASUREMENT', FUN = function(obj, event){

  obj$weight <- get_body_attr(event, 'weight')
  obj$height <- get_body_attr(event, 'height')
  return(obj)

})

death_handler <- handler(type = 'DEATH', FUN = function(obj, event){
  obj$death_date <- get_body_attr(event, 'death_date')
  return(obj)
})

handlers <- add_handler(birth_handler, death_handler)

handlers_01 <- birth_handler \%>\%
  add_handler(measurement_handler) \%>\%
  add_handler(death_handler)

handlers_02 <- birth_handler +
  measurement_handler +
  death_handler

identical(handlers_01, handlers_02)

}
