% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{pinv}
\alias{pinv}
\alias{ginv.evgam}
\title{Moore-Penrose pseudo-inverse of a matrix}
\usage{
pinv(x, tol = -1)

ginv.evgam(x, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{a matrix}

\item{tol}{a scalar}
}
\value{
A matrix
}
\description{
Moore-Penrose pseudo-inverse of a matrix
}
\details{
This function is merely a wrapper for Armadillo's pinv function with its
default settings, which, in particular uses the divide-and-conquer
method. If \code{tol} isn't provided Armadillo's default for pinv is used.
\code{ginv.evgam} mimics \link[MASS]{ginv} using Armadillo's pinv.
}
\references{
http://arma.sourceforge.net/docs.html#pinv
}
\seealso{
\link[MASS]{ginv}
}
