% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.multi.URW.R
\name{sim.multi.URW}
\alias{sim.multi.URW}
\title{Simulate multivariate evolutionary sequence data that evolve according to an Unbiased Random Walk}
\usage{
sim.multi.URW(
  ns = 30,
  anc = c(0, 0),
  R = matrix(c(0.5, 0, 0, 0.5), nrow = 2, byrow = TRUE),
  vp = 0.1,
  nn = rep(30, ns),
  tt = 0:(ns - 1)
)
}
\arguments{
\item{ns}{number of samples in time-series}

\item{anc}{the ancestral trait values}

\item{R}{the drift matrix}

\item{vp}{within-population trait variance}

\item{nn}{vector of the number of individuals in each sample (identical sample sizes for all time-series is assumed)}

\item{tt}{vector of sample ages, increases from oldest to youngest}
}
\value{
A multivariate evolutionary sequence (time-series) data set.
}
\description{
Function to simulate multivariate evolutionary sequence data that evolve according to an Unbiased Random Walk
}
\examples{
## Create a multivariate dataset
data_set<-sim.multi.URW(40, R = matrix(c(0.2,0.1,0.1,0.3), nrow=2, byrow = TRUE))

## plot the data
plotevoTS.multivariate(data_set)

}
\author{
Kjetil Lysne Voje
}
