% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DriftTest.R
\name{PlotTreeDriftTest}
\alias{PlotTreeDriftTest}
\title{Plot results from TreeDriftTest}
\usage{
PlotTreeDriftTest(test.list, tree, ...)
}
\arguments{
\item{test.list}{Output from TreeDriftTest}

\item{tree}{phylogenetic tree}

\item{...}{adition arguments to plot}
}
\description{
Plot which labels reject drift hypothesis.
}
\examples{
library(ape)
data(bird.orders)

tree <- bird.orders
mean.list <- llply(tree$tip.label, function(x) rnorm(5))
names(mean.list) <- tree$tip.label
cov.matrix.list <- RandomMatrix(5, length(tree$tip.label))
names(cov.matrix.list) <- tree$tip.label
sample.sizes <- runif(length(tree$tip.label), 15, 20)

test.list <- TreeDriftTest(tree, mean.list, cov.matrix.list, sample.sizes)
PlotTreeDriftTest(test.list, tree)
}
\author{
Diogo Melo
}
\seealso{
DriftTest TreeDriftTest
}

