% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploration.R
\name{plot_points}
\alias{plot_points}
\title{Scatter plot of sessions}
\usage{
plot_points(sessions, start = getOption("evprof.start.hour"), log = FALSE, ...)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof
\href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{standard format}.}

\item{start}{integer, start hour in the x axis of the plot.
This is only used when \code{log = FALSE}.}

\item{log}{logical, whether to transform \code{ConnectionStartDateTime} and
\code{ConnectionHours} variables to natural logarithmic scale (base = \code{exp(1)}).}

\item{...}{arguments to \code{ggplot2::geom_point} function}
}
\value{
ggplot scatter plot
}
\description{
Scatter plot of sessions
}
\examples{
library(dplyr)
california_ev_sessions \%>\% head(3000) \%>\% plot_points()
california_ev_sessions \%>\% head(3000) \%>\% plot_points(start = 3)
california_ev_sessions \%>\% head(3000) \%>\% plot_points(log = TRUE)

}
