% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENNreg.R
\name{ENNreg}
\alias{ENNreg}
\title{Training the ENNreg model}
\usage{
ENNreg(
  X,
  y,
  init = NULL,
  K = NULL,
  batch = TRUE,
  nstart = 100,
  c = 1,
  lambda = 0.9,
  xi = 0,
  rho = 0,
  eps = NULL,
  nu = 1e-16,
  optimProto = TRUE,
  verbose = TRUE,
  options = list(maxiter = 1000, rel.error = 1e-04, print = 10),
  opt.rmsprop = list(batch_size = 100, epsi = 0.001, rho = 0.9, delta = 1e-08, Dtmax =
    100)
)
}
\arguments{
\item{X}{Input matrix of size n x p, where n is the number of objects and p the number of
attributes.}

\item{y}{Vector of length n containing observations of the response variable.}

\item{init}{Initial model generated by \code{\link{ENNreg_init}} (default=NULL).}

\item{K}{Number of prototypes (default=NULL; must be supplied if initial model is not supplied).}

\item{batch}{If TRUE (default), batch learning is used; otherwise, online learning is
used.}

\item{nstart}{Number of random starts of the k-means algorithm (default: 100, used only if initial
model is not supplied).}

\item{c}{Multiplicative coefficient applied to scale parameter gamma (defaut: 1, used only if
initial model is not supplied)}

\item{lambda}{Parameter of the loss function (default=0.9)}

\item{xi}{Regularization coefficient penalizing precision (default=0).}

\item{rho}{Regularization coefficient shrinking the solution towards a linear model (default=0).}

\item{eps}{Parameter of the loss function (if NULL, set to 0.01 times the standard deviation of y).}

\item{nu}{Parameter of the loss function to avoid a division par zero (default=1e-16).}

\item{optimProto}{If TRUE (default), the initial prototypes are optimized.}

\item{verbose}{If TRUE (default) intermediate results are displayed.}

\item{options}{Parameters of the optimization procedure (see details).}

\item{opt.rmsprop}{Parameters of the RMSprop algorithm (see details).}
}
\value{
An object of class "ENNreg"  with the following components:
\describe{
\item{loss}{Value of the loss function.}
\item{param}{Parameter values.}
\item{K}{Number of prototypes.}
\item{pred}{Predictions on the training set (a list containing the prototype unit activations,
the output means, variances and precisions, as well as the lower and upper expectations).}
}
}
\description{
\code{ENNreg} trains the ENNreg model using batch or minibatch learning procedures.
}
\details{
If \code{batch=TRUE}, function \code{harris} from package \code{evclust} is used for
optimization. Otherwise, the RMSprop minibatch learning algorithm is used. The three
parameters in list \code{options} are:
\describe{
  \item{maxiter}{Maximum number of iterations (default: 100).}
  \item{rel.error}{Relative error for stopping criterion (default: 1e-4).}
  \item{print}{Number of iterations between two displays (default: 10).}
 }
Additional parameters for the RMSprop, used only if \code{batch=FALSE}, are contained in
list \code{opt.rmsprop}. They are:
' \describe{
  \item{batch_size}{Minibatch size.}
  \item{epsi}{Global learning rate.}
  \item{rho}{Decay rate.}
  \item{delta}{Small constant to stabilize division by small numbers.}
  \item{Dtmax}{The algorithm stops when the loss has not decreased in the last Dtmax
  iterations.}
 }
}
\examples{
# Boston dataset
\donttest{
library(MASS)
X<-as.matrix(scale(Boston[,1:13]))
y<-Boston[,14]
set.seed(220322)
n<-nrow(Boston)
ntrain<-round(0.7*n)
train <-sample(n,ntrain)
fit <- ENNreg(X[train,],y[train],K=30)
plot(y[train],fit$pred$mux,xlab="observed response",ylab="predicted response")
}

}
\references{
Thierry Denoeux. An evidential neural network model for regression based on random fuzzy
numbers. In "Belief functions: Theory and applications (proc. of BELIEF 2022)", pages 57-66,
Springer, 2022.

Thierry Denoeux. Quantifying prediction uncertainty in regression using random fuzzy sets: the ENNreg
model. TechRxiv preprint, 2023b
}
\seealso{
\code{\link{predict.ENNreg}}, \code{\link{ENNreg_init}}, \code{\link{ENNreg_cv}},
\code{\link{ENNreg_holdout}}
}
