% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evmodel.R
\name{get_connection_models_from_parameters}
\alias{get_connection_models_from_parameters}
\title{Get connection Gaussian Mixture Models from parameters}
\usage{
get_connection_models_from_parameters(
  time_cycle_parameters,
  connection_log = FALSE
)
}
\arguments{
\item{time_cycle_parameters}{tibble with Gaussian Mixture Models parameters.
This tibble must have the following columns: \code{profile},    \code{ratio} (in \%),    \code{start_mean} (in hours),
\code{start_sd} (in hours),    \code{duration_mean} (in hours),    \code{duration_sd} (in hours),    \code{energy_mean} (in kWh),    \code{energy_sd} (in kWh).}

\item{connection_log}{logical, true if connection models have logarithmic transformations}
}
\value{
connection GMM tibble
}
\description{
Get connection Gaussian Mixture Models from parameters
}
\examples{
# For workdays time cycle
workdays_parameters <- dplyr::tibble(
  profile = c("Worktime", "Visit"),
  ratio = c(80, 20),
  start_mean = c(9, 11),
  start_sd = c(1, 4),
  duration_mean = c(8, 4),
  duration_sd = c(0.5, 2),
  energy_mean = c(15, 6),
  energy_sd = c(4, 3)
)

# For weekends time cycle
weekends_parameters <- dplyr::tibble(
  profile = "Visit",
  ratio = 100,
  start_mean = 12,
  start_sd = 4,
  duration_mean = 3,
  duration_sd = 2,
  energy_mean = 4,
  energy_sd = 4
)

connection_GMM <- purrr::map(
  list(Workdays = workdays_parameters, Weekends = weekends_parameters),
  ~ get_connection_models_from_parameters(.x)
)


}
