% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/human-hMoI.R
\name{make_parameters_X_hMoI}
\alias{make_parameters_X_hMoI}
\title{Make parameters for hybrid MoI human model}
\usage{
make_parameters_X_hMoI(pars, b, c1, c2, r1, r2, Psi, wf = 1, m10, m20, H)
}
\arguments{
\item{pars}{an \link{environment}}

\item{b}{transmission probability (efficiency) from mosquito to human}

\item{c1}{transmission probability (efficiency) from inapparent human infections to mosquito}

\item{c2}{transmission probability (efficiency) from patent human infections to mosquito}

\item{r1}{recovery rate from inapparent infections}

\item{r2}{recovery rate from patent infections}

\item{Psi}{a \link{matrix} of dimensions \code{nPatches} by \code{nStrata}}

\item{wf}{vector of biting weights of length \code{nStrata}}

\item{m10}{mean MoI among inapparent human infections}

\item{m20}{mean MoI among patent human infections}

\item{H}{size of human population in each strata}
}
\value{
a \link{list} with class \code{hMoI}.
}
\description{
MoI stands for Multiplicity of Infection, and refers to malarial superinfection.
}
