% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{lr.rd}
\alias{lr.rd}
\title{Likelihood ratio statistics for one-sided tests of risk difference.}
\usage{
lr.rd(
  n0,
  n1,
  Y0 = NULL,
  Y1 = NULL,
  psi = 0,
  sided = 1,
  mod = 1e-07,
  dec.places = 10
)
}
\arguments{
\item{n0}{control sample size}

\item{n1}{treatment sample size}

\item{Y0}{number of successes for control (see details)}

\item{Y1}{number of successes for treatment (see details)}

\item{psi}{null value of risk difference p1-p0}

\item{sided}{(1 or 2 sided test)
#' @param sided 1-sided or 2-sided test}

\item{mod}{A very small adjustment to account for 0*log0 in certain
likelihood calculations. Should not need adjustment.}

\item{dec.places}{number of decimal places of t-values and p-value.}
}
\value{
A list with elements \item{y0,y1}{data sets (scalar or vector)}
\item{T, P}{quasi-exact P-value(s) and equivalent T-value(s)}
\item{pmle}{profile ML estimates of baseline probability}
\item{index}{consistent code to select a single outcome} \item{psi}{scalar
null value of p1-p0}
}
\description{
Calculates all possible values of the (signed) LR statistic for testing
p1-p0 greater than a provided null value psi.
}
\details{
If Y0,Y1 is not supplied then all possible values are output. If specific
values for Y0, Y1 are supplied then only these outcomes of the SRLR are
calculated.
}
\references{
C.J. Lloyd (2022) Exact samples sizes for clinical trials subject to
size and power constraints. Preprint. \doi{10.13140/RG.2.2.11828.94085}
}
\author{
Chris J. Lloyd
}
\keyword{internal}
