% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ch03CTT.R
\name{AlphaCoefficient}
\alias{AlphaCoefficient}
\title{Alpha Coefficient}
\usage{
AlphaCoefficient(x, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{x}{This should be a data matrix or a Covariance/Phi/Tetrachoric matrix.}

\item{na}{This parameter identifies the numbers or characters that should be treated as missing values when 'x' is a data matrix.}

\item{Z}{This parameter represents a missing indicator matrix. It is only needed if 'x' is a data matrix.}

\item{w}{This parameter is an item weight vector. It is only required if 'x' is a data matrix.}
}
\value{
For a correlation/covariance matrix input, returns a single numeric value
representing the alpha coefficient. For a data matrix input, returns a list with
three components:
\itemize{
\item AlphaCov: Alpha coefficient calculated from covariance matrix
\item AlphaPhi: Alpha coefficient calculated from phi coefficient matrix
\item AlphaTetrachoric: Alpha coefficient calculated from tetrachoric correlation matrix
}
}
\description{
This function computes Tau-Equivalent Measurement, also known as Cronbach's alpha coefficient, for a given data set.
}
\references{
Cronbach, L. J. (1951). Coefficient alpha and the internal structure of a test. Psychometrika, 16,297–334.
}
