% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{distribution}
\alias{distribution}
\alias{compute_cdf}
\alias{compute_pmdf}
\alias{compute_probability}
\alias{point_probability}
\alias{pprob}
\alias{is_distribution}
\alias{distribution.default}
\alias{quantile.distribution}
\alias{cdf}
\alias{print.distribution}
\alias{summary.distribution}
\alias{pmdf}
\alias{toLatex.distribution}
\alias{is.distribution}
\alias{prob}
\alias{prob1}
\title{Class Distribution}
\usage{
distribution(name, ...)

\method{distribution}{default}(name, ..., discrete = NA)

\method{quantile}{distribution}(x, probs = seq(0, 1, 0.25), ...)

cdf(x, q, ...)

\method{print}{distribution}(x, ...)

\method{summary}{distribution}(object, ...)

pmdf(d, x, ...)

\method{toLatex}{distribution}(object, name = NULL, param = NULL, digits = 4, ...)

is.distribution(object, name = NULL)

prob(d, min = -Inf, max = +Inf, tol = 1e-06)

prob1(d, x, tol = 1e-06)

compute_cdf(x, q, ...)

compute_pmdf(d, x, ...)

compute_probability(d, min = -Inf, max = +Inf, tol = 1e-06)

point_probability(d, x, tol = 1e-06)

pprob(d, x, tol = 1e-06)

is_distribution(object, name = NULL)
}
\arguments{
\item{name}{character: a replacement of the name of the distribution type}

\item{...}{further named distribution parameters}

\item{discrete}{logical: is the distribution discrete? (default: \code{NA})}

\item{x}{vector of values}

\item{probs}{numeric: vector of probabilities with values in \eqn{[0,1]}.}

\item{q}{numeric: vector of quantiles}

\item{object}{distribution object}

\item{d}{distribution}

\item{param}{character: names for the distribution parameters}

\item{digits}{integer: number of digits used in \code{signif}}

\item{min}{numeric: left border of interval}

\item{max}{numeric: right border of interval}

\item{tol}{numeric: tolerance for \code{max==min} (default: \code{1e-6})}
}
\value{
A distribution object.
}
\description{
Holds an univariate distribution including its parameters. The name of the distribution is used to determine the right use of the function.
For example, in the case of function for quantiles: \code{paste0("q", name)}. Usually the full name has to be used; some abbreviated names are possible:
\itemize{
\item{\code{binom}} binomial distribution, parameters: \code{size}, \code{prob}
\item{\code{hyper}} hypergeometric distribution, parameters: \code{m}, \code{n}, \code{k}
\item{\code{geom}} geometric distribution, parameters: \code{prob}
\item{\code{pois}} Poisson distribution, parameters: \code{lambda}
\item{\code{unif}} continuous uniform  distribution, parameters: \code{min}, \code{max}
\item{\code{dunif}} discrete uniform  distribution, parameters: \code{min}, \code{max}
\item{\code{dunif2}} continuous uniform  distribution, parameters: \code{min}, \code{max}
\item{\code{exp}} exponential distribution, parameter: \code{rate}
\item{\code{norm}} normal distribution, parameters: \code{mean}, \code{sd}
\item{\code{lnorm}} log-normal distribution, parameters: \code{meanlog}, \code{sdlog}
\item{\code{t}} Student t distribution, parameter: \code{df}
\item{\code{chisq}} chi-squared distribution, parameter: \code{df}
\item{\code{f}} F distribution, parameters: \code{df1},  \code{df2}
}
Note that a probability mass/density, quantile and a cumulative distribution function must exist.

The following functions exists for \code{disributions}:
\itemize{
\item{\code{distribution}} creates a distribution with \code{name} and parameters
\item{\code{quantile}} computes the quantiles of a distribution using \code{paste0('q', name)}
\item{\code{cdf}} computes the cumulative distribution function of a distribution using \code{paste0('p', name)}
\item{\code{pmdf}} computes the probability mass/density function of a distribution using \code{paste0('d', name)}
\item{\code{prob}} computes the probability for a interval between \code{min} and \code{max} (\code{max} included, \code{min} excluded)
\item{\code{prob1}} computes the point probability f
\item{\code{is.distribution}} checks if \code{object} is distribution object. If \code{name} is given then it checks whether the distribution type is the same
\item{\code{toLatex}} generates a LaTeX representation of the distribution an its parameter
}
}
\examples{
d <- distribution("norm", mean=0, sd=1)
quantile(d)
quantile(d, c(0.025, 0.975))
cdf(d, 0)
is.distribution(d)
is.distribution(d, "t")
toLatex(d)
}
