% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histx.R
\name{histx}
\alias{histx}
\alias{gen_mid}
\alias{dhistx}
\title{Midpoint-Based Data Creation for a Histogram}
\usage{
histx(breaks, n, alpha = 0.99)

gen_mid(breaks, n, alpha = 0.99)

dhistx(breaks, n, alpha = 0.99)
}
\arguments{
\item{breaks}{numeric: class borders}

\item{n}{numeric: number of observations in each class}

\item{alpha}{numeric: how far the generated observations can be away from the class mids (default: \code{0.99})}
}
\value{
The generated data set.
}
\description{
Given the breaks and the number of observations, a data set is generated with \code{\link[stats:Uniform]{stats::runif()}}, using
the class mids: \eqn{x_i = class\_mid_j + alpha*class\_width_j/2}. The default \code{alpha=0.99} ensures that
generated observations do not lie on the class borders.
}
\examples{
breaks <- sort(sample(seq(0.1, 0.9, by=0.1), 4))
bins   <- length(breaks)-1
n      <- rmultinom(1, size=100, prob=ddiscrete(runif(bins)))
histx(breaks, n) 
}
