% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmr_data.R
\name{lmr_data}
\alias{lmr_data}
\alias{lm_regression_data}
\title{\code{lm} Simple Linear Regression}
\usage{
lmr_data(xr, yr, n, r = 0, digits = NULL, ...)

lm_regression_data(xr, yr, n, r = 0, digits = NULL, ...)
}
\arguments{
\item{xr}{numeric: range of x values}

\item{yr}{numeric: range of y values}

\item{n}{numeric: number of observations to generate}

\item{r}{numeric: desired correlation, uses \code{cor_data}}

\item{digits}{numeric(2): digits for rounding, for x \code{digits[1]} is used, for y \code{digits[2]} is used (default: \code{NULL})}

\item{...}{further parameters used in \code{cor_data}}
}
\value{
An object of the class \code{lm} with the additional components:
\itemize{
\item \code{x} the generated x values
\item \code{y} the generated y values
\item \code{sumx} \eqn{\sum_{i=1}^n x_i}
\item \code{sumy} \eqn{\sum_{i=1}^n y_i}
\item \code{sumx2} \eqn{\sum_{i=1}^n x_i^2}
\item \code{sumy2} \eqn{\sum_{i=1}^n y_i^2}
\item \code{sumxy} \eqn{\sum_{i=1}^n x_i y_i}
\item \code{meanx} the mean of x: \eqn{1/n \sum_{i=1}^n x_i}
\item \code{meany} the mean of y: \eqn{1/n \sum_{i=1}^n y_i}
\item \code{varx} the variation of x: \eqn{\sum_{i=1}^n (x_i-\bar{x})^2}
\item \code{vary} the variation of y: \eqn{\sum_{i=1}^n (y_i-\bar{y})^2}
\item \code{varxy} the common variation of x and y:\eqn{\sum_{i=1}^n (x_i-\bar{x})(y_i-\bar{y})}
\item \code{sxy} the covariance of x and y
\item \code{rxy} the correlation of x and y
\item \code{b0} the intercept of the linear regression
\item \code{b1} the slope of the linear regression
\item \code{r2} the coefficient of determination of the linear regression
}
}
\description{
Computes an \code{lm} object for a simple linear regression from a range of \code{x} and \code{y} values,
including intermediate values. If \code{r} is not given then zero correlation is used (with \code{cor_data}).
\code{digits} determines the rounding for the \code{x} and \code{y} values. If only one value is given, then
it will be used for \code{x} and \code{y}. If no value is given then it will be determined from
the \code{x} and \code{y} values by \code{3+ceiling(-log10(diff(range(.))))}.
}
\examples{
# Engine displacement typically ranges from 500 to 2000 cm^3
# Fuel economy typically ranges from 2 to 8 liter/100 km
lmr <- lmr_data(c(500, 2000), c(2, 8), n=8)
str(lmr)
}
