% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomial.R
\name{toString.polynomial}
\alias{toString.polynomial}
\title{Text Representation of a Polynomial}
\usage{
\method{toString}{polynomial}(
  x,
  digits = TRUE,
  decreasing = FALSE,
  variable = "x",
  simplify = TRUE,
  tol = 1e-09,
  ...
)
}
\arguments{
\item{x}{polynomial: vector of coefficients (first is intercept)}

\item{digits}{numeric or logical: how to convert to text (default: \code{NA})}

\item{decreasing}{logical:  order of the terms by increasing or decreasing powers (default:  \code{FALSE})}

\item{variable}{character: name of the variable used (default: \code{"x"})}

\item{simplify}{logical: should the polynomial representation be simplified (default: \code{TRUE})}

\item{tol}{numeric: tolerance (default: \code{1e-9}). A negative value will keep zeros and ones too, but:
\itemize{
\item If a coefficient is smaller than \code{tol} then zero terms are not kept.
\item If a absolute value of coefficient minus one is smaller than \code{tol} then coefficient is not kept
}}

\item{...}{unused parameters}
}
\value{
A character
}
\description{
Creates a text representation for a polynomial, in the following scenarios:
\itemize{
\item if \code{digits} is \code{TRUE} then \code{as.character(.)} is used
\item if \code{digits} is \code{FALSE} then \code{./.} is used
\item if \code{digits} is numeric then \code{as.character(round(., digits))} is used
}
}
\examples{
p <- polynomial(c(-1,0,2)/3)
toString(p, 4)
toString(p, FALSE)
toString(p, TRUE)
toString(p, variable="z")
toString(p, decreasing=TRUE)
p <- polynomial(c(0,1,2)/3)
toString(p)
toString(p, tol=-1)
}
