% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xl.workbooks.R
\name{xl.workbook.add}
\alias{xl.workbook.activate}
\alias{xl.workbook.add}
\alias{xl.workbook.close}
\alias{xl.workbook.open}
\alias{xl.workbook.save}
\alias{xl.workbooks}
\title{Basic operations with Excel workbooks}
\usage{
xl.workbook.add(filename = NULL)

xl.workbook.open(filename, password = NULL)

xl.workbook.activate(xl.workbook.name)

xl.workbooks()

xl.workbook.save(filename, password = NULL)

xl.workbook.close(xl.workbook.name = NULL)
}
\arguments{
\item{filename}{character. Excel workbook filename.}

\item{password}{character. Password for password-protected workbook.}

\item{xl.workbook.name}{character. Excel workbook name.}
}
\value{
\itemize{
\item{\code{xl.workbook.add}/\code{xl.workbook.open}/\code{xl.workbook.activate}
}{ invisibly return name of created/open/activated workbook.}
\item{\code{xl.workbooks}}{ returns character vector of open workbooks.}
\item{\code{xl.workbook.save}}{ invisibly returns path to the saved workbook}
\item{\code{xl.workbook.close}}{ invisibly returns NULL.} }
}
\description{
Basic operations with Excel workbooks
}
\details{
\itemize{ \item{\code{xl.workbook.add}}{ adds new workbook and
invisibly returns name of this newly created workbook. Added workbook become
active. If \code{filename} argument is provided then Excel workbook
\code{filename} will be used as template.}
\item{\code{xl.workbook.activate}}{ activates workbook with given name. If
workbook with this name doesn't exist error will be generated.}
\item{\code{xl.workbook.save}}{ saves active workbook. If only
\code{filename} submitted it saves in the working directory. If name of
workbook is omitted than new workbook is saved under its default name in the
current working directory. It doesn't prompt about overwriting if file
already exists.} \item{\code{xl.workbook.close}}{ closes workbook with given
name. If name isn't submitted it closed active workbook.  It doesn't prompt
about saving so if you don't save changes before closing all changes will be
lost.} }
}
\examples{
\dontrun{
## senseless actions
data(iris)
data(cars)
xl.workbook.add()
xlrc[a1] = iris
xl.workbook.save("iris.xlsx")
xl.workbook.add()
xlrc[a1] = cars
xl.workbook.save("cars.xlsx")
xl.workbook.activate("iris")
xl.workbook.close("cars")
xl.workbook.open("cars.xlsx")
xl.workbooks()
for (wb in xl.workbooks()) xl.workbook.close(wb)
unlink("iris.xlsx")
unlink("cars.xlsx")

# password-protected workbook
data(iris)
xl.workbook.add()
xlrc[a1] = iris
xl.workbook.save("iris.xlsx", password = "my_password")
xl.workbook.close()
xl.workbook.open("iris.xlsx", password = "my_password")
xl.workbook.close()
unlink("iris.xlsx")
}
}
\seealso{
\code{\link{xl.sheets}}, \code{\link{xl.read.file}},
  \code{\link{xl.save.file}}
}

