% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{check_duplicates}
\alias{check_duplicates}
\title{Check for duplicate IP addresses and/or locations}
\usage{
check_duplicates(
  x,
  id_col = "ResponseId",
  ip_col = "IPAddress",
  location_col = c("LocationLatitude", "LocationLongitude"),
  dupl_ip = TRUE,
  dupl_location = TRUE,
  include_na = FALSE,
  keep = FALSE,
  quiet = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{ip_col}{Column name for IP addresses.}

\item{location_col}{Two element vector specifying columns for latitude and
longitude (in that order).}

\item{dupl_ip}{Logical indicating whether to check IP addresses.}

\item{dupl_location}{Logical indicating whether to check latitude and
longitude.}

\item{include_na}{Logical indicating whether to include rows with NAs for
IP address and location as potentially excluded rows.}

\item{keep}{Logical indicating whether to keep or remove exclusion column.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}
}
\value{
An object of the same type as \code{x} that includes the rows with
duplicate IP addresses and/or locations. This includes a column
called dupe_count that returns the number of duplicates.
For a function that marks these rows, use \code{\link[=mark_duplicates]{mark_duplicates()}}.
For a function that excludes these rows, use \code{\link[=exclude_duplicates]{exclude_duplicates()}}.
}
\description{
The \code{check_duplicates()} function subsets rows of data, retaining rows
that have the same IP address and/or same latitude and longitude. The
function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
By default, IP address and location are both checked, but they can be
checked separately with the \code{dupl_ip} and \code{dupl_location} arguments.

The function outputs to console separate messages about the number of
rows with duplicate IP addresses and rows with duplicate locations.
These counts are computed independently, so rows may be counted for both
types of duplicates.
}
\examples{
# Check for duplicate IP addresses and locations
data(qualtrics_text)
check_duplicates(qualtrics_text)

# Check only for duplicate locations
qualtrics_text \%>\%
  check_duplicates(dupl_location = FALSE)

# Do not print rows to console
qualtrics_text \%>\%
  check_duplicates(print = FALSE)

# Do not print message to console
qualtrics_text \%>\%
  check_duplicates(quiet = TRUE)
}
\seealso{
Other duplicates functions: 
\code{\link{exclude_duplicates}()},
\code{\link{mark_duplicates}()}

Other check functions: 
\code{\link{check_duration}()},
\code{\link{check_ip}()},
\code{\link{check_location}()},
\code{\link{check_preview}()},
\code{\link{check_progress}()},
\code{\link{check_resolution}()}
}
\concept{check functions}
\concept{duplicates functions}
