% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_matrix_test.R
\name{imt_stat}
\alias{imt_stat}
\title{Statistics for the information matrix test}
\usage{
imt_stat(data, theta, u, k = 1, inc_cens = TRUE)
}
\arguments{
\item{data}{A numeric vector of raw data.  Missing values are allowed, but
they should not appear between non-missing values, that is, they only be
located at the start and end of the vector.  Missing values are omitted
using \code{\link[stats]{na.omit}}.}

\item{theta}{A numeric scalar. An estimate of the extremal index
\eqn{\theta}, produced by \code{\link{kgaps}}.}

\item{u}{A numeric scalar.  Extreme value threshold applied to data.}

\item{k}{A numeric scalar.  Run parameter \eqn{K}, as defined in Suveges and
Davison (2010).  Threshold inter-exceedances times that are not larger
than \code{k} units are assigned to the same cluster, resulting in a
\eqn{K}-gap equal to zero.  Specifically, the \eqn{K}-gap \eqn{S}
corresponding to an inter-exceedance time of \eqn{T} is given by
\eqn{S = \max(T - K, 0)}{S = max(T - K, 0)}.}

\item{inc_cens}{A logical scalar indicating whether or not to include
contributions from censored inter-exceedance times relating to the
first and last observation.  See Attalides (2015) for details.}
}
\value{
A list relating the quantities given on pages 18-19 of
  Suveges and Davison (2010).  All but the last component are vectors giving
  the contribution to the quantity from each \eqn{K}-gap, evaluated at the
  input value \code{theta} of \eqn{\theta}.
  \item{\code{ldj} }{the derivative of the log-likelihood with respect to
    \eqn{\theta} (the score)}
  \item{\code{Ij} }{the observed information}
  \item{\code{Jj} }{the square of the score}
  \item{\code{dj} }{\code{Jj} - \code{Ij}}
  \item{\code{Ddj} }{the derivative of \code{Jj} - \code{Ij} with respect
    to \eqn{\theta}}
  \item{\code{n_kgaps} }{the number of \eqn{K}-gaps.}
}
\description{
Calculates the components required to calculate the value of the information
matrix test under the \eqn{K}-gaps model, using vector data input.
Called by \code{\link{kgaps_imt}}.
}
\references{
Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{The Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \doi{10.1214/09-AOAS292}

Attalides, N. (2015) Threshold-based extreme value modelling,
  PhD thesis, University College London.
  \url{https://discovery.ucl.ac.uk/1471121/1/Nicolas_Attalides_Thesis.pdf}
}
