% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exdex.R
\docType{data}
\name{cheeseboro}
\alias{cheeseboro}
\title{Cheeseboro hourly maximum wind gusts}
\format{
A 744 by 10 numeric matrix.  Column \code{i} contains the hourly
  maximum wind gusts (in miles per hour) from Cheeseboro in the year
  2000 + \code{i} - 1. The columns are named 2000, 2001, ..., 2009 and the
  rows are named day\code{j}hour\code{k}, where \code{j} is the day of the
  month and \code{k} the hour of the day.
}
\source{
The Remote Automated Weather Stations USA Climate Archive at
  \url{https://raws.dri.edu/}, more specifically the Daily Summaries of the
  \href{https://raws.dri.edu/cgi-bin/rawMAIN.pl?caCCHB}{Cheeseboro page}.
}
\usage{
cheeseboro
}
\description{
The matrix \code{cheeseboro} contains hourly maximum wind gusts (in miles
per hour) recorded at the Cheeseboro weather station near Thousand Oaks,
Southern California, USA during the month of January over the period
2000-2009. These data are analysed in Reich and Shaby (2016).
}
\note{
There are 42 missing values, located in 6 of the 10 years, namely
  2000-2003 and 2005-2006.
}
\references{
Reich, B. J. and Shaby, B. A. (2016). 'Time series of Extremes',
in Dey, D. K. and Yan, J. (eds.) Extreme Value Modeling and Risk Analysis.
New York: Chapman and Hall/CRC, pp. 131-151.
}
\keyword{datasets}
